/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class SetDevicesPropertyRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private List<String> deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Items")
    @Validation(required=true)
    private String items;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private SetDevicesPropertyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.items = builder.items;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetDevicesPropertyRequest create() {
        return SetDevicesPropertyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getItems() {
        return this.items;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static final class Builder
    extends Request.Builder<SetDevicesPropertyRequest, Builder> {
        private List<String> deviceName;
        private String iotInstanceId;
        private String items;
        private String productKey;

        private Builder() {
        }

        private Builder(SetDevicesPropertyRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.items = request.items;
            this.productKey = request.productKey;
        }

        public Builder deviceName(List<String> deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder items(String items) {
            this.putQueryParameter("Items", items);
            this.items = items;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public SetDevicesPropertyRequest build() {
            return new SetDevicesPropertyRequest(this);
        }
    }
}

