/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class SetEdgeInstanceDriverConfigsRequest
extends Request {
    @Query
    @NameInMap(value="Configs")
    @Validation(required=true)
    private List<Configs> configs;
    @Query
    @NameInMap(value="DriverId")
    @Validation(required=true)
    private String driverId;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private SetEdgeInstanceDriverConfigsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.configs = builder.configs;
        this.driverId = builder.driverId;
        this.instanceId = builder.instanceId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetEdgeInstanceDriverConfigsRequest create() {
        return SetEdgeInstanceDriverConfigsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Configs> getConfigs() {
        return this.configs;
    }

    public String getDriverId() {
        return this.driverId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static class Configs
    extends TeaModel {
        @NameInMap(value="Content")
        @Validation(required=true)
        private String content;
        @NameInMap(value="Format")
        @Validation(required=true)
        private String format;
        @NameInMap(value="Key")
        private String key;

        private Configs(Builder builder) {
            this.content = builder.content;
            this.format = builder.format;
            this.key = builder.key;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Configs create() {
            return Configs.builder().build();
        }

        public String getContent() {
            return this.content;
        }

        public String getFormat() {
            return this.format;
        }

        public String getKey() {
            return this.key;
        }

        public static final class Builder {
            private String content;
            private String format;
            private String key;

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Configs build() {
                return new Configs(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<SetEdgeInstanceDriverConfigsRequest, Builder> {
        private List<Configs> configs;
        private String driverId;
        private String instanceId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(SetEdgeInstanceDriverConfigsRequest request) {
            super((Request)request);
            this.configs = request.configs;
            this.driverId = request.driverId;
            this.instanceId = request.instanceId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder configs(List<Configs> configs) {
            this.putQueryParameter("Configs", configs);
            this.configs = configs;
            return this;
        }

        public Builder driverId(String driverId) {
            this.putQueryParameter("DriverId", driverId);
            this.driverId = driverId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public SetEdgeInstanceDriverConfigsRequest build() {
            return new SetEdgeInstanceDriverConfigsRequest(this);
        }
    }
}

