/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SpeechBySynthesisRequest
extends Request {
    @Body
    @NameInMap(value="AudioFormat")
    @Validation(required=true)
    private String audioFormat;
    @Body
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Body
    @NameInMap(value="IotId")
    private String iotId;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="ProductKey")
    private String productKey;
    @Body
    @NameInMap(value="SpeechId")
    private String speechId;
    @Body
    @NameInMap(value="SpeechRate")
    @Validation(maximum=500.0)
    private Integer speechRate;
    @Body
    @NameInMap(value="Text")
    @Validation(required=true)
    private String text;
    @Body
    @NameInMap(value="Voice")
    @Validation(required=true)
    private String voice;
    @Body
    @NameInMap(value="Volume")
    @Validation(maximum=100.0)
    private Integer volume;

    private SpeechBySynthesisRequest(Builder builder) {
        super((Request.Builder)builder);
        this.audioFormat = builder.audioFormat;
        this.deviceName = builder.deviceName;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.speechId = builder.speechId;
        this.speechRate = builder.speechRate;
        this.text = builder.text;
        this.voice = builder.voice;
        this.volume = builder.volume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SpeechBySynthesisRequest create() {
        return SpeechBySynthesisRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAudioFormat() {
        return this.audioFormat;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getSpeechId() {
        return this.speechId;
    }

    public Integer getSpeechRate() {
        return this.speechRate;
    }

    public String getText() {
        return this.text;
    }

    public String getVoice() {
        return this.voice;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public static final class Builder
    extends Request.Builder<SpeechBySynthesisRequest, Builder> {
        private String audioFormat;
        private String deviceName;
        private String iotId;
        private String iotInstanceId;
        private String productKey;
        private String speechId;
        private Integer speechRate;
        private String text;
        private String voice;
        private Integer volume;

        private Builder() {
        }

        private Builder(SpeechBySynthesisRequest request) {
            super((Request)request);
            this.audioFormat = request.audioFormat;
            this.deviceName = request.deviceName;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.speechId = request.speechId;
            this.speechRate = request.speechRate;
            this.text = request.text;
            this.voice = request.voice;
            this.volume = request.volume;
        }

        public Builder audioFormat(String audioFormat) {
            this.putBodyParameter("AudioFormat", audioFormat);
            this.audioFormat = audioFormat;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putBodyParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putBodyParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putBodyParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder speechId(String speechId) {
            this.putBodyParameter("SpeechId", speechId);
            this.speechId = speechId;
            return this;
        }

        public Builder speechRate(Integer speechRate) {
            this.putBodyParameter("SpeechRate", speechRate);
            this.speechRate = speechRate;
            return this;
        }

        public Builder text(String text) {
            this.putBodyParameter("Text", text);
            this.text = text;
            return this;
        }

        public Builder voice(String voice) {
            this.putBodyParameter("Voice", voice);
            this.voice = voice;
            return this;
        }

        public Builder volume(Integer volume) {
            this.putBodyParameter("Volume", volume);
            this.volume = volume;
            return this;
        }

        public SpeechBySynthesisRequest build() {
            return new SpeechBySynthesisRequest(this);
        }
    }
}

