/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class SubscribeTopicRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private String deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="Topic")
    @Validation(required=true)
    private List<String> topic;

    private SubscribeTopicRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.topic = builder.topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubscribeTopicRequest create() {
        return SubscribeTopicRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public List<String> getTopic() {
        return this.topic;
    }

    public static final class Builder
    extends Request.Builder<SubscribeTopicRequest, Builder> {
        private String deviceName;
        private String iotInstanceId;
        private String productKey;
        private List<String> topic;

        private Builder() {
        }

        private Builder(SubscribeTopicRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.topic = request.topic;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder topic(List<String> topic) {
            this.putQueryParameter("Topic", topic);
            this.topic = topic;
            return this;
        }

        public SubscribeTopicRequest build() {
            return new SubscribeTopicRequest(this);
        }
    }
}

