/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class TriggerSceneRuleRequest
extends Request {
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="RuleId")
    @Validation(required=true)
    private String ruleId;

    private TriggerSceneRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceId = builder.instanceId;
        this.iotInstanceId = builder.iotInstanceId;
        this.ruleId = builder.ruleId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TriggerSceneRuleRequest create() {
        return TriggerSceneRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public static final class Builder
    extends Request.Builder<TriggerSceneRuleRequest, Builder> {
        private String instanceId;
        private String iotInstanceId;
        private String ruleId;

        private Builder() {
        }

        private Builder(TriggerSceneRuleRequest request) {
            super((Request)request);
            this.instanceId = request.instanceId;
            this.iotInstanceId = request.iotInstanceId;
            this.ruleId = request.ruleId;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder ruleId(String ruleId) {
            this.putQueryParameter("RuleId", ruleId);
            this.ruleId = ruleId;
            return this;
        }

        public TriggerSceneRuleRequest build() {
            return new TriggerSceneRuleRequest(this);
        }
    }
}

