/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class UpdateJobRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JobId")
    @Validation(required=true)
    private String jobId;
    @Query
    @NameInMap(value="RolloutConfig")
    private Map<String, ?> rolloutConfig;
    @Query
    @NameInMap(value="TimeoutConfig")
    private Map<String, ?> timeoutConfig;

    private UpdateJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.iotInstanceId = builder.iotInstanceId;
        this.jobId = builder.jobId;
        this.rolloutConfig = builder.rolloutConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateJobRequest create() {
        return UpdateJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Map<String, ?> getRolloutConfig() {
        return this.rolloutConfig;
    }

    public Map<String, ?> getTimeoutConfig() {
        return this.timeoutConfig;
    }

    public static final class Builder
    extends Request.Builder<UpdateJobRequest, Builder> {
        private String description;
        private String iotInstanceId;
        private String jobId;
        private Map<String, ?> rolloutConfig;
        private Map<String, ?> timeoutConfig;

        private Builder() {
        }

        private Builder(UpdateJobRequest request) {
            super((Request)request);
            this.description = request.description;
            this.iotInstanceId = request.iotInstanceId;
            this.jobId = request.jobId;
            this.rolloutConfig = request.rolloutConfig;
            this.timeoutConfig = request.timeoutConfig;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder rolloutConfig(Map<String, ?> rolloutConfig) {
            String rolloutConfigShrink = this.shrink(rolloutConfig, "RolloutConfig", "json");
            this.putQueryParameter("RolloutConfig", rolloutConfigShrink);
            this.rolloutConfig = rolloutConfig;
            return this;
        }

        public Builder timeoutConfig(Map<String, ?> timeoutConfig) {
            String timeoutConfigShrink = this.shrink(timeoutConfig, "TimeoutConfig", "json");
            this.putQueryParameter("TimeoutConfig", timeoutConfigShrink);
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }
    }
}

