/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateParserRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="ParserId")
    @Validation(required=true, maximum=9.999999999E9)
    private Long parserId;

    private UpdateParserRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.iotInstanceId = builder.iotInstanceId;
        this.name = builder.name;
        this.parserId = builder.parserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateParserRequest create() {
        return UpdateParserRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public static final class Builder
    extends Request.Builder<UpdateParserRequest, Builder> {
        private String description;
        private String iotInstanceId;
        private String name;
        private Long parserId;

        private Builder() {
        }

        private Builder(UpdateParserRequest request) {
            super((Request)request);
            this.description = request.description;
            this.iotInstanceId = request.iotInstanceId;
            this.name = request.name;
            this.parserId = request.parserId;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder parserId(Long parserId) {
            this.putQueryParameter("ParserId", parserId);
            this.parserId = parserId;
            return this;
        }

        public UpdateParserRequest build() {
            return new UpdateParserRequest(this);
        }
    }
}

