/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateProductFilterConfigRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="PropertyTimestampFilter")
    @Validation(required=true)
    private Boolean propertyTimestampFilter;
    @Query
    @NameInMap(value="PropertyValueFilter")
    @Validation(required=true)
    private Boolean propertyValueFilter;

    private UpdateProductFilterConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.propertyTimestampFilter = builder.propertyTimestampFilter;
        this.propertyValueFilter = builder.propertyValueFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateProductFilterConfigRequest create() {
        return UpdateProductFilterConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public Boolean getPropertyTimestampFilter() {
        return this.propertyTimestampFilter;
    }

    public Boolean getPropertyValueFilter() {
        return this.propertyValueFilter;
    }

    public static final class Builder
    extends Request.Builder<UpdateProductFilterConfigRequest, Builder> {
        private String iotInstanceId;
        private String productKey;
        private Boolean propertyTimestampFilter;
        private Boolean propertyValueFilter;

        private Builder() {
        }

        private Builder(UpdateProductFilterConfigRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.propertyTimestampFilter = request.propertyTimestampFilter;
            this.propertyValueFilter = request.propertyValueFilter;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder propertyTimestampFilter(Boolean propertyTimestampFilter) {
            this.putQueryParameter("PropertyTimestampFilter", propertyTimestampFilter);
            this.propertyTimestampFilter = propertyTimestampFilter;
            return this;
        }

        public Builder propertyValueFilter(Boolean propertyValueFilter) {
            this.putQueryParameter("PropertyValueFilter", propertyValueFilter);
            this.propertyValueFilter = propertyValueFilter;
            return this;
        }

        public UpdateProductFilterConfigRequest build() {
            return new UpdateProductFilterConfigRequest(this);
        }
    }
}

