/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateProductRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="ProductName")
    @Validation(required=true)
    private String productName;

    private UpdateProductRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.productName = builder.productName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateProductRequest create() {
        return UpdateProductRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getProductName() {
        return this.productName;
    }

    public static final class Builder
    extends Request.Builder<UpdateProductRequest, Builder> {
        private String description;
        private String iotInstanceId;
        private String productKey;
        private String productName;

        private Builder() {
        }

        private Builder(UpdateProductRequest request) {
            super((Request)request);
            this.description = request.description;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.productName = request.productName;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder productName(String productName) {
            this.putQueryParameter("ProductName", productName);
            this.productName = productName;
            return this;
        }

        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }
    }
}

