/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateProductTagsRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="ProductTag")
    @Validation(required=true)
    private List<ProductTag> productTag;

    private UpdateProductTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.productTag = builder.productTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateProductTagsRequest create() {
        return UpdateProductTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public List<ProductTag> getProductTag() {
        return this.productTag;
    }

    public static class ProductTag
    extends TeaModel {
        @NameInMap(value="TagKey")
        private String tagKey;
        @NameInMap(value="TagValue")
        private String tagValue;

        private ProductTag(Builder builder) {
            this.tagKey = builder.tagKey;
            this.tagValue = builder.tagValue;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ProductTag create() {
            return ProductTag.builder().build();
        }

        public String getTagKey() {
            return this.tagKey;
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public static final class Builder {
            private String tagKey;
            private String tagValue;

            public Builder tagKey(String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            public Builder tagValue(String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            public ProductTag build() {
                return new ProductTag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateProductTagsRequest, Builder> {
        private String iotInstanceId;
        private String productKey;
        private List<ProductTag> productTag;

        private Builder() {
        }

        private Builder(UpdateProductTagsRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.productTag = request.productTag;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder productTag(List<ProductTag> productTag) {
            this.putQueryParameter("ProductTag", productTag);
            this.productTag = productTag;
            return this;
        }

        public UpdateProductTagsRequest build() {
            return new UpdateProductTagsRequest(this);
        }
    }
}

