/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.io.InputStream;
import java.util.List;

public class RecognizeMultiLanguageRequest
extends Request {
    @Query
    @NameInMap(value="Languages")
    @Validation(required=true)
    private List<String> languages;
    @Query
    @NameInMap(value="NeedRotate")
    private Boolean needRotate;
    @Query
    @NameInMap(value="NeedSortPage")
    private Boolean needSortPage;
    @Query
    @NameInMap(value="OutputCharInfo")
    private Boolean outputCharInfo;
    @Query
    @NameInMap(value="OutputTable")
    private Boolean outputTable;
    @Query
    @NameInMap(value="Url")
    private String url;
    @Body
    @NameInMap(value="body")
    private InputStream body;

    private RecognizeMultiLanguageRequest(Builder builder) {
        super((Request.Builder)builder);
        this.languages = builder.languages;
        this.needRotate = builder.needRotate;
        this.needSortPage = builder.needSortPage;
        this.outputCharInfo = builder.outputCharInfo;
        this.outputTable = builder.outputTable;
        this.url = builder.url;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RecognizeMultiLanguageRequest create() {
        return RecognizeMultiLanguageRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public Boolean getNeedRotate() {
        return this.needRotate;
    }

    public Boolean getNeedSortPage() {
        return this.needSortPage;
    }

    public Boolean getOutputCharInfo() {
        return this.outputCharInfo;
    }

    public Boolean getOutputTable() {
        return this.outputTable;
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<RecognizeMultiLanguageRequest, Builder> {
        private List<String> languages;
        private Boolean needRotate;
        private Boolean needSortPage;
        private Boolean outputCharInfo;
        private Boolean outputTable;
        private String url;
        private InputStream body;

        private Builder() {
        }

        private Builder(RecognizeMultiLanguageRequest request) {
            super((Request)request);
            this.languages = request.languages;
            this.needRotate = request.needRotate;
            this.needSortPage = request.needSortPage;
            this.outputCharInfo = request.outputCharInfo;
            this.outputTable = request.outputTable;
            this.url = request.url;
            this.body = request.body;
        }

        public Builder languages(List<String> languages) {
            String languagesShrink = this.shrink(languages, "Languages", "simple");
            this.putQueryParameter("Languages", languagesShrink);
            this.languages = languages;
            return this;
        }

        public Builder needRotate(Boolean needRotate) {
            this.putQueryParameter("NeedRotate", needRotate);
            this.needRotate = needRotate;
            return this;
        }

        public Builder needSortPage(Boolean needSortPage) {
            this.putQueryParameter("NeedSortPage", needSortPage);
            this.needSortPage = needSortPage;
            return this;
        }

        public Builder outputCharInfo(Boolean outputCharInfo) {
            this.putQueryParameter("OutputCharInfo", outputCharInfo);
            this.outputCharInfo = outputCharInfo;
            return this;
        }

        public Builder outputTable(Boolean outputTable) {
            this.putQueryParameter("OutputTable", outputTable);
            this.outputTable = outputTable;
            return this;
        }

        public Builder url(String url) {
            this.putQueryParameter("Url", url);
            this.url = url;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public RecognizeMultiLanguageRequest build() {
            return new RecognizeMultiLanguageRequest(this);
        }
    }
}

