/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class VerifyVATInvoiceRequest
extends Request {
    @Query
    @NameInMap(value="InvoiceCode")
    private String invoiceCode;
    @Query
    @NameInMap(value="InvoiceDate")
    @Validation(required=true)
    private String invoiceDate;
    @Query
    @NameInMap(value="InvoiceNo")
    @Validation(required=true)
    private String invoiceNo;
    @Query
    @NameInMap(value="InvoiceSum")
    private String invoiceSum;
    @Query
    @NameInMap(value="VerifyCode")
    private String verifyCode;

    private VerifyVATInvoiceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.invoiceCode = builder.invoiceCode;
        this.invoiceDate = builder.invoiceDate;
        this.invoiceNo = builder.invoiceNo;
        this.invoiceSum = builder.invoiceSum;
        this.verifyCode = builder.verifyCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VerifyVATInvoiceRequest create() {
        return VerifyVATInvoiceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInvoiceCode() {
        return this.invoiceCode;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public String getInvoiceNo() {
        return this.invoiceNo;
    }

    public String getInvoiceSum() {
        return this.invoiceSum;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public static final class Builder
    extends Request.Builder<VerifyVATInvoiceRequest, Builder> {
        private String invoiceCode;
        private String invoiceDate;
        private String invoiceNo;
        private String invoiceSum;
        private String verifyCode;

        private Builder() {
        }

        private Builder(VerifyVATInvoiceRequest request) {
            super((Request)request);
            this.invoiceCode = request.invoiceCode;
            this.invoiceDate = request.invoiceDate;
            this.invoiceNo = request.invoiceNo;
            this.invoiceSum = request.invoiceSum;
            this.verifyCode = request.verifyCode;
        }

        public Builder invoiceCode(String invoiceCode) {
            this.putQueryParameter("InvoiceCode", invoiceCode);
            this.invoiceCode = invoiceCode;
            return this;
        }

        public Builder invoiceDate(String invoiceDate) {
            this.putQueryParameter("InvoiceDate", invoiceDate);
            this.invoiceDate = invoiceDate;
            return this;
        }

        public Builder invoiceNo(String invoiceNo) {
            this.putQueryParameter("InvoiceNo", invoiceNo);
            this.invoiceNo = invoiceNo;
            return this;
        }

        public Builder invoiceSum(String invoiceSum) {
            this.putQueryParameter("InvoiceSum", invoiceSum);
            this.invoiceSum = invoiceSum;
            return this;
        }

        public Builder verifyCode(String verifyCode) {
            this.putQueryParameter("VerifyCode", verifyCode);
            this.verifyCode = verifyCode;
            return this;
        }

        public VerifyVATInvoiceRequest build() {
            return new VerifyVATInvoiceRequest(this);
        }
    }
}

