/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.pai_dsw20220101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateInstanceSnapshotRequest
extends Request {
    @Path
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Body
    @NameInMap(value="ExcludePaths")
    private List<String> excludePaths;
    @Body
    @NameInMap(value="ImageUrl")
    @Validation(required=true)
    private String imageUrl;
    @Body
    @NameInMap(value="Labels")
    private List<Labels> labels;
    @Body
    @NameInMap(value="Overwrite")
    private Boolean overwrite;
    @Body
    @NameInMap(value="SnapshotDescription")
    private String snapshotDescription;
    @Body
    @NameInMap(value="SnapshotName")
    @Validation(required=true)
    private String snapshotName;

    private CreateInstanceSnapshotRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceId = builder.instanceId;
        this.excludePaths = builder.excludePaths;
        this.imageUrl = builder.imageUrl;
        this.labels = builder.labels;
        this.overwrite = builder.overwrite;
        this.snapshotDescription = builder.snapshotDescription;
        this.snapshotName = builder.snapshotName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateInstanceSnapshotRequest create() {
        return CreateInstanceSnapshotRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<String> getExcludePaths() {
        return this.excludePaths;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public List<Labels> getLabels() {
        return this.labels;
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public String getSnapshotDescription() {
        return this.snapshotDescription;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public static class Labels
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Labels(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Labels create() {
            return Labels.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            private Builder() {
            }

            private Builder(Labels model) {
                this.key = model.key;
                this.value = model.value;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Labels build() {
                return new Labels(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateInstanceSnapshotRequest, Builder> {
        private String instanceId;
        private List<String> excludePaths;
        private String imageUrl;
        private List<Labels> labels;
        private Boolean overwrite;
        private String snapshotDescription;
        private String snapshotName;

        private Builder() {
        }

        private Builder(CreateInstanceSnapshotRequest request) {
            super((Request)request);
            this.instanceId = request.instanceId;
            this.excludePaths = request.excludePaths;
            this.imageUrl = request.imageUrl;
            this.labels = request.labels;
            this.overwrite = request.overwrite;
            this.snapshotDescription = request.snapshotDescription;
            this.snapshotName = request.snapshotName;
        }

        public Builder instanceId(String instanceId) {
            this.putPathParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder excludePaths(List<String> excludePaths) {
            this.putBodyParameter("ExcludePaths", excludePaths);
            this.excludePaths = excludePaths;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.putBodyParameter("ImageUrl", imageUrl);
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder labels(List<Labels> labels) {
            this.putBodyParameter("Labels", labels);
            this.labels = labels;
            return this;
        }

        public Builder overwrite(Boolean overwrite) {
            this.putBodyParameter("Overwrite", overwrite);
            this.overwrite = overwrite;
            return this;
        }

        public Builder snapshotDescription(String snapshotDescription) {
            this.putBodyParameter("SnapshotDescription", snapshotDescription);
            this.snapshotDescription = snapshotDescription;
            return this;
        }

        public Builder snapshotName(String snapshotName) {
            this.putBodyParameter("SnapshotName", snapshotName);
            this.snapshotName = snapshotName;
            return this;
        }

        public CreateInstanceSnapshotRequest build() {
            return new CreateInstanceSnapshotRequest(this);
        }
    }
}

