/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.pai_dsw20220101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListInstanceSnapshotRequest
extends Request {
    @Path
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="Order")
    private String order;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;

    private ListInstanceSnapshotRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceId = builder.instanceId;
        this.order = builder.order;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListInstanceSnapshotRequest create() {
        return ListInstanceSnapshotRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getOrder() {
        return this.order;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public static final class Builder
    extends Request.Builder<ListInstanceSnapshotRequest, Builder> {
        private String instanceId;
        private String order;
        private Long pageNumber;
        private Long pageSize;
        private String sortBy;

        private Builder() {
        }

        private Builder(ListInstanceSnapshotRequest request) {
            super((Request)request);
            this.instanceId = request.instanceId;
            this.order = request.order;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
        }

        public Builder instanceId(String instanceId) {
            this.putPathParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder order(String order) {
            this.putQueryParameter("Order", order);
            this.order = order;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public ListInstanceSnapshotRequest build() {
            return new ListInstanceSnapshotRequest(this);
        }
    }
}

