/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.cache;

import com.aliyuncs.kms.secretsmanager.client.cache.CacheSecretStoreStrategy;
import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.model.CacheSecretInfo;
import com.aliyuncs.kms.secretsmanager.client.model.SecretInfo;
import com.aliyuncs.kms.secretsmanager.client.utils.AES256Utils;
import com.aliyuncs.kms.secretsmanager.client.utils.ArrayUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.JsonIOUtils;
import com.aliyuncs.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileCacheSecretStoreStrategy
implements CacheSecretStoreStrategy {
    private static final String JSON_FILE_NAME_PREFIX = "stage_";
    private static final String JSON_FILE_NAME_SUFFIX = ".json";
    private String cacheSecretPath;
    private boolean reloadOnStart;
    private String salt;
    private Set<String> reloadedSet = new HashSet<String>();
    private final Map<String, CacheSecretInfo> cacheSecretInfoMap = new ConcurrentHashMap<String, CacheSecretInfo>();

    public FileCacheSecretStoreStrategy() {
    }

    public FileCacheSecretStoreStrategy(String cacheSecretPath, boolean reloadOnStart, String salt) {
        this.cacheSecretPath = cacheSecretPath;
        this.reloadOnStart = reloadOnStart;
        this.salt = salt;
    }

    @Override
    public void init() throws CacheSecretException {
        if (StringUtils.isEmpty((CharSequence)this.cacheSecretPath)) {
            this.cacheSecretPath = ".";
        }
        if (StringUtils.isEmpty((CharSequence)this.salt)) {
            throw new IllegalArgumentException("the argument[salt] must not be null");
        }
    }

    @Override
    public void storeSecret(CacheSecretInfo cacheSecretInfo) throws CacheSecretException {
        CacheSecretInfo memoryCacheSecretInfo = cacheSecretInfo.clone();
        CacheSecretInfo fileCacheSecretInfo = cacheSecretInfo.clone();
        SecretInfo secretInfo = fileCacheSecretInfo.getSecretInfo();
        String secretValue = secretInfo.getSecretValue();
        secretInfo.setSecretValue(this.encryptSecretVale(secretValue, this.generateRandomKey()));
        String fileName = (JSON_FILE_NAME_PREFIX + cacheSecretInfo.getStage() + JSON_FILE_NAME_SUFFIX).toLowerCase();
        String cacheSecretPath = this.cacheSecretPath + File.separatorChar + secretInfo.getSecretName();
        if (JsonIOUtils.exists(cacheSecretPath, fileName)) {
            JsonIOUtils.delete(cacheSecretPath, fileName);
        }
        JsonIOUtils.writeObject(cacheSecretPath, fileName, fileCacheSecretInfo);
        this.cacheSecretInfoMap.put(secretInfo.getSecretName(), memoryCacheSecretInfo);
        this.reloadedSet.add(cacheSecretInfo.getSecretInfo().getSecretName());
    }

    @Override
    public CacheSecretInfo getCacheSecretInfo(String secretName) throws CacheSecretException {
        if (!this.reloadOnStart && !this.reloadedSet.contains(secretName)) {
            return null;
        }
        CacheSecretInfo memoryCacheSecretInfo = this.cacheSecretInfoMap.get(secretName);
        if (memoryCacheSecretInfo != null) {
            return memoryCacheSecretInfo;
        }
        String fileName = "stage_ACSCurrent.json".toLowerCase();
        String cacheSecretPath = this.cacheSecretPath + File.separatorChar + secretName;
        CacheSecretInfo cacheSecretInfo = JsonIOUtils.readObject(cacheSecretPath, fileName, CacheSecretInfo.class);
        if (cacheSecretInfo != null) {
            SecretInfo secretInfo = cacheSecretInfo.getSecretInfo();
            secretInfo.setSecretValue(this.decryptSecretVale(secretInfo.getSecretValue()));
            this.cacheSecretInfoMap.put(secretInfo.getSecretName(), cacheSecretInfo);
        }
        return cacheSecretInfo;
    }

    private String encryptSecretVale(String secretValue, byte[] key) throws CacheSecretException {
        byte[] iv = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(System.currentTimeMillis());
        secureRandom.nextBytes(iv);
        byte[] bytes = ArrayUtils.concatAll("001".getBytes(), key, iv, AES256Utils.encrypt("001", secretValue.getBytes(), key, iv, this.salt));
        return Base64.getEncoder().encodeToString(bytes);
    }

    private String decryptSecretVale(String secretValue) throws CacheSecretException {
        byte[] decodeBytes = Base64.getDecoder().decode(secretValue);
        byte[] modeKeyBytes = Arrays.copyOfRange(decodeBytes, 0, "001".getBytes().length);
        byte[] keyBytes = Arrays.copyOfRange(decodeBytes, "001".getBytes().length, "001".getBytes().length + 32);
        byte[] ivBytes = Arrays.copyOfRange(decodeBytes, "001".getBytes().length + 32, "001".getBytes().length + 32 + 16);
        byte[] secretBytes = Arrays.copyOfRange(decodeBytes, "001".getBytes().length + 32 + 16, decodeBytes.length);
        return AES256Utils.decrypt(new String(modeKeyBytes), secretBytes, keyBytes, ivBytes, this.salt);
    }

    private byte[] generateRandomKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return bytes;
    }

    @Override
    public void close() throws IOException {
    }
}

