/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpHeader;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import com.aliyun.sdk.gateway.oss.util.Mimetypes;
import darabonba.core.TeaRequest;
import darabonba.core.TeaRequestBody;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import java.util.Arrays;
import java.util.List;

public class AddContentTypeHeaderInterceptor
implements RequestInterceptor {
    private static final String MIMETYPE_DEFAULT = "application/octet-stream";
    private static final List<String> ALLOW_ACTIONS = Arrays.asList("PutObject", "AppendObject", "CopyObject", "InitiateMultipartUpload");

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        HttpHeader header = request.headers().get("Content-Type");
        if (header == null) {
            TeaRequestBody requestBody = (TeaRequestBody)attributes.get(AttributeKey.REQUEST_BODY);
            if (requestBody.contentType().isPresent()) {
                request.headers().set("Content-Type", (String)requestBody.contentType().get());
            } else {
                request.headers().set("Content-Type", this.lookupMimeType(request));
            }
        }
        return request;
    }

    private String lookupMimeType(TeaRequest request) {
        if (!ALLOW_ACTIONS.contains(request.action())) {
            return MIMETYPE_DEFAULT;
        }
        return Mimetypes.getInstance().getMimetype(request.pathname());
    }
}

