/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.models.Response;
import com.aliyun.sdk.gateway.oss.models.ResponseMetadata;
import darabonba.core.TeaModel;
import darabonba.core.TeaPair;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.OutputInterceptor;
import darabonba.core.utils.CommonUtil;
import java.util.Map;

public class FinalizedOutputInterceptor
implements OutputInterceptor {
    public TeaModel modifyOutput(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        Map headers = response.httpResponse().getHeaders().toCaseInsensitiveMap();
        Map model = CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", response.deserializedBody()), new TeaPair("headers", (Object)headers)});
        TeaModel.adjustToModel((Map)model, (TeaModel)context.output());
        this.updateResponseMembersIfNeed(context, headers);
        return context.output();
    }

    private void updateResponseMembersIfNeed(InterceptorContext context, Map<String, String> headers) {
        if (context.output() instanceof Response) {
            Response res = (Response)context.output();
            context.setOutput(res.toBuilder().responseMetadata(new ResponseMetadata(headers)).httpStatusCode(context.teaResponse().httpResponse().getStatusCode()).build());
        }
    }
}

