/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpHeader;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.internal.HttpUtil;
import darabonba.core.TeaRequest;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.interceptor.ResponseInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class UrlDecodeEncodeInterceptor
implements RequestInterceptor,
ResponseInterceptor {
    private static final List<String> REQUEST_ALLOW_ACTIONS = Arrays.asList("PutSymlink");
    private static final List<String> RESPONSE_ALLOW_ACTIONS = Arrays.asList("ListObjects", "ListObjectsV2", "ListObjectVersions", "DeleteMultipleObjects", "ListMultipartUploads", "ListParts", "GetSymlink", "InitiateMultipartUpload", "CompleteMultipartUpload");

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        String action;
        TeaRequest request = context.teaRequest();
        if (this.shouldHandleRequest(request, action = context.teaRequest().action())) {
            switch (action) {
                case "PutSymlink": {
                    request = this.modifyPutSymlinkRequest(request);
                    break;
                }
            }
        }
        return request;
    }

    private static String urlEncode(String v) {
        return HttpUtil.urlEncode(v, "utf-8");
    }

    private boolean shouldHandleRequest(TeaRequest request, String action) {
        return REQUEST_ALLOW_ACTIONS.contains(action);
    }

    private TeaRequest modifyPutSymlinkRequest(TeaRequest request) {
        HttpHeader header = request.headers().get("x-oss-symlink-target");
        if (header != null) {
            request.headers().set("x-oss-symlink-target", UrlDecodeEncodeInterceptor.urlEncode(header.getValue()));
        }
        return request;
    }

    private static Object urlDecode(String v) {
        return HttpUtil.urlDecode(v, "utf-8");
    }

    private static ArrayList<?> urlDecodeInList(HashMap root, String node, String key) {
        Object obj = root.get(node);
        ArrayList list = null;
        if (List.class.isAssignableFrom(obj.getClass())) {
            list = (ArrayList)obj;
        } else {
            list = new ArrayList();
            list.add(obj);
        }
        return (ArrayList)list.stream().map(o -> {
            HashMap m = (HashMap)o;
            m.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)m.get(key)));
            return o;
        }).collect(Collectors.toList());
    }

    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        String action;
        TeaResponse response = context.teaResponse();
        if (this.shouldHandleResponse(response, action = context.teaRequest().action())) {
            switch (action) {
                case "ListObjects": {
                    response = this.modifyListObjectsResponse(response);
                    break;
                }
                case "ListObjectsV2": {
                    response = this.modifyListObjectsV2Response(response);
                    break;
                }
                case "ListObjectVersions": {
                    response = this.modifyListObjectVersionsResponse(response);
                    break;
                }
                case "DeleteMultipleObjects": {
                    response = this.modifyDeleteMultipleObjectsResponse(response);
                    break;
                }
                case "ListMultipartUploads": {
                    response = this.modifyListMultipartUploadsResponse(response);
                    break;
                }
                case "ListParts": {
                    response = this.modifyListPartsResponse(response);
                    break;
                }
                case "GetSymlink": {
                    response = this.modifyGetSymlinkResponse(response);
                    break;
                }
                case "InitiateMultipartUpload": {
                    response = this.modifyInitiateMultipartUploadResponse(response);
                    break;
                }
                case "CompleteMultipartUpload": {
                    response = this.modifyCompleteMultipartUploadResponse(response);
                    break;
                }
            }
        }
        return response;
    }

    private boolean shouldHandleResponse(TeaResponse response, String action) {
        if (!response.success() || response.exception() != null) {
            return false;
        }
        return RESPONSE_ALLOW_ACTIONS.contains(action);
    }

    private TeaResponse modifyListObjectsResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("ListBucketResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Delimiter", "Marker", "Prefix", "NextMarker");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            if (root.containsKey("Contents")) {
                root.replace("Contents", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "Contents", "Key"));
            }
            if (root.containsKey("CommonPrefixes")) {
                root.replace("CommonPrefixes", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "CommonPrefixes", "Prefix"));
            }
            body.replace("ListBucketResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyListObjectsV2Response(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("ListBucketResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Delimiter", "StartAfter", "Prefix");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            if (root.containsKey("Contents")) {
                root.replace("Contents", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "Contents", "Key"));
            }
            if (root.containsKey("CommonPrefixes")) {
                root.replace("CommonPrefixes", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "CommonPrefixes", "Prefix"));
            }
            body.replace("ListBucketResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyListObjectVersionsResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("ListVersionsResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Delimiter", "KeyMarker", "NextKeyMarker", "Prefix");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            if (root.containsKey("Version")) {
                root.replace("Version", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "Version", "Key"));
            }
            if (root.containsKey("DeleteMarker")) {
                root.replace("DeleteMarker", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "DeleteMarker", "Key"));
            }
            if (root.containsKey("CommonPrefixes")) {
                root.replace("CommonPrefixes", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "CommonPrefixes", "Prefix"));
            }
            body.replace("ListVersionsResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyDeleteMultipleObjectsResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("DeleteResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            if (root.containsKey("Deleted")) {
                root.replace("Deleted", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "Deleted", "Key"));
            }
            body.replace("DeleteResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyListMultipartUploadsResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("ListMultipartUploadsResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Delimiter", "KeyMarker", "NextKeyMarker", "Prefix");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            if (root.containsKey("Upload")) {
                root.replace("Upload", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "Upload", "Key"));
            }
            if (root.containsKey("CommonPrefixes")) {
                root.replace("CommonPrefixes", UrlDecodeEncodeInterceptor.urlDecodeInList(root, "CommonPrefixes", "Prefix"));
            }
            body.replace("ListMultipartUploadsResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyListPartsResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("ListPartsResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Key");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            body.replace("ListPartsResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyGetSymlinkResponse(TeaResponse response) {
        HttpResponse httpResponse = response.httpResponse();
        HttpHeader header = httpResponse.getHeaders().get("x-oss-symlink-target");
        if (header != null) {
            httpResponse.getHeaders().set("x-oss-symlink-target", (String)UrlDecodeEncodeInterceptor.urlDecode(header.getValue()));
        }
        return response;
    }

    private TeaResponse modifyInitiateMultipartUploadResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("InitiateMultipartUploadResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Key");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            body.replace("InitiateMultipartUploadResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }

    private TeaResponse modifyCompleteMultipartUploadResponse(TeaResponse response) {
        HashMap body = (HashMap)response.deserializedBody();
        HashMap root = (HashMap)body.get("CompleteMultipartUploadResult");
        if (root != null && root.getOrDefault("EncodingType", "").equals("url")) {
            List<String> Keys = Arrays.asList("Key");
            for (String key : Keys) {
                if (!root.containsKey(key)) continue;
                root.replace(key, UrlDecodeEncodeInterceptor.urlDecode((String)root.get(key)));
            }
            body.replace("CompleteMultipartUploadResult", root);
            response.setDeserializedBody((Object)body);
        }
        return response;
    }
}

