package com.aliyun.sdk.gateway.pop.models;

import com.aliyun.core.annotation.NameInMap;

public class CommonResponse extends Response {
    @NameInMap("headers")
    private java.util.Map<String, String> headers;

    @NameInMap("body")
    private Object body;

    private CommonResponse(BuilderImpl builder) {
        super(builder);
        this.headers = builder.headers;
        this.body = builder.body;
    }

    public static CommonResponse create() {
        return new BuilderImpl().build();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    /**
     * @return headers
     */
    public java.util.Map<String, String> getHeaders() {
        return this.headers;
    }

    /**
     * @return body
     */
    public Object getBody() {
        return this.body;
    }

    public interface Builder extends Response.Builder<CommonResponse, Builder> {

        Builder headers(java.util.Map<String, String> headers);

        Builder body(Object body);

        @Override
        CommonResponse build();

    }

    private static final class BuilderImpl
            extends Response.BuilderImpl<CommonResponse, Builder>
            implements Builder {
        private java.util.Map<String, String> headers;
        private Object body;

        private BuilderImpl() {
            super();
        }

        private BuilderImpl(CommonResponse response) {
            super(response);
            this.headers = response.headers;
            this.body = response.body;
        }

        /**
         * headers.
         */
        @Override
        public Builder headers(java.util.Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        /**
         * body.
         */
        @Override
        public Builder body(Object body) {
            this.body = body;
            return this;
        }

        @Override
        public CommonResponse build() {
            return new CommonResponse(this);
        }

    }
}

