/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.response;

import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.core.utils.StringUtils;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;

public class PopResInterceptor
implements ResponseInterceptor {
    private final ClientLogger logger = new ClientLogger(PopResInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        this.logger.verbose("PopResponse process begin.");
        TeaResponse teaResponse = context.teaResponse();
        if (teaResponse.success()) {
            Object response = null;
            try (HttpResponse httpResponse = teaResponse.httpResponse();){
                switch (context.teaRequest().bodyType()) {
                    case "byte": {
                        response = httpResponse.getBodyAsByteArray();
                        break;
                    }
                    case "binary": 
                    case "string": {
                        String bodyStr = httpResponse.getBodyAsString();
                        response = bodyStr;
                        break;
                    }
                    case "json": {
                        String bodyStr = httpResponse.getBodyAsString();
                        if (StringUtils.isEmpty((CharSequence)bodyStr)) break;
                        response = CommonUtil.assertAsMap((Object)ParseUtil.readAsJSON((String)bodyStr));
                        break;
                    }
                    case "array": {
                        String bodyStr = httpResponse.getBodyAsString();
                        if (StringUtils.isEmpty((CharSequence)bodyStr)) break;
                        response = CommonUtil.assertAsArray((Object)ParseUtil.readAsJSON((String)httpResponse.getBodyAsString()));
                        break;
                    }
                    default: {
                        String bodyStr = httpResponse.getBodyAsString();
                        response = bodyStr;
                    }
                }
                teaResponse.setDeserializedBody(response);
            }
        }
        return teaResponse;
    }
}

