package com.aliyun.auth.credentials;

import com.aliyun.core.utils.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Credential implements ICredential {
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String securityToken;

    public static final Credential ANONYMOUS_CREDENTIALS = Credential
            .builder()
            .accessKeyId(null)
            .accessKeyId(null)
            .securityToken(null)
            .build();

    private Credential(Builder builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accessKeySecret = builder.accessKeySecret;
        this.securityToken = builder.securityToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String accessKeyId() {
        return accessKeyId;
    }

    public String accessKeySecret() {
        return accessKeySecret;
    }

    public String securityToken() {
        return securityToken;
    }

    @Override
    public String toString() {
        Map<String, Object> fieldMap = new HashMap<>();
        fieldMap.put("accessKeyId", accessKeyId);
        fieldMap.put("accessKeySecret", accessKeySecret);
        fieldMap.put("securityToken", securityToken);
        return StringUtils.toAliString("Credential", fieldMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Credential that = (Credential) o;
        return Objects.equals(accessKeyId, that.accessKeyId) &&
                Objects.equals(accessKeySecret, that.accessKeySecret);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(accessKeySecret());
        return hashCode;
    }

    public static final class Builder {
        private String accessKeyId;
        private String accessKeySecret;
        private String securityToken;

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public Credential build() {
            return new Credential(this);
        }
    }
}
