package com.aliyun.core.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;

@Documented
@Retention(RUNTIME)
@Target({FIELD, METHOD})
public @interface Validation {
    String pattern() default "";

    int maxLength() default 0;

    int minLength() default 0;

    double maximum() default Double.MAX_VALUE;

    double minimum() default Double.MIN_VALUE;

    boolean required() default false;
}
