package com.aliyun.core.mock;

import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.http.HttpRequest;

import java.util.concurrent.CompletableFuture;

/**
 * An HttpClient instance that does not do anything.
 */
public class NoOpHttpClient implements HttpClient {

    @Override
    public CompletableFuture<HttpResponse> send(HttpRequest request) {
        return CompletableFuture.completedFuture(null); // NOP
    }

    @Override
    public void close() {
    }

}
