/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.regions;

import com.aliyuncs.auth.Credential;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.regions.Endpoint;
import com.aliyuncs.regions.IEndpointsProvider;
import com.aliyuncs.regions.LocationConfig;
import com.aliyuncs.regions.ProductDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CustomizedEndpointsParser
implements IEndpointsProvider {
    private List<Endpoint> endpoints;

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public List<Endpoint> getEndpoints() throws ClientException {
        return this.endpoints;
    }

    @Override
    public List<Endpoint> getEndpoints(String region, String product, Credential credential, LocationConfig locationConfig) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public static CustomizedEndpointsParser initParser(String regionId, Map<String, String> productDomainMap) {
        CustomizedEndpointsParser parser = new CustomizedEndpointsParser();
        if (regionId == null || regionId.length() == 0 || productDomainMap == null) {
            return null;
        }
        HashSet<String> regionIds = new HashSet<String>();
        regionIds.add(regionId);
        ArrayList<ProductDomain> productDomainList = new ArrayList<ProductDomain>();
        for (String productName : productDomainMap.keySet()) {
            productDomainList.add(new ProductDomain(productName, productDomainMap.get(productName)));
        }
        Endpoint endpoint = new Endpoint(regionId, regionIds, productDomainList);
        parser.setEndpoints(Arrays.asList(endpoint));
        return parser;
    }
}

