/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.regions;

import com.aliyuncs.AcsError;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.auth.ShaHmac1Singleton;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.regions.DescribeEndpointRequest;
import com.aliyuncs.regions.DescribeEndpointResponse;
import com.aliyuncs.regions.Endpoint;
import com.aliyuncs.regions.IEndpointsProvider;
import com.aliyuncs.regions.LocationConfig;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.transform.UnmarshallerContext;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RemoteEndpointsParser
implements IEndpointsProvider {
    private ConcurrentMap<String, List<Endpoint>> endpointMap = new ConcurrentHashMap<String, List<Endpoint>>();
    private static final Map<String, String> productMap = new ConcurrentHashMap<String, String>();

    @Override
    public List<Endpoint> getEndpoints() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Endpoint> getEndpoints(String regionId, String product, Credential credential, LocationConfig locationConfig) throws ClientException {
        List<Endpoint> endpoints = (List<Endpoint>)this.endpointMap.get(product);
        if (endpoints != null) {
            return endpoints;
        }
        DescribeEndpointResponse response = this.loadEndpoint(regionId, product, credential, locationConfig);
        if (response == null) {
            return endpoints;
        }
        HashSet<String> regionIds = new HashSet<String>();
        regionIds.add(response.getRegionId());
        List<ProductDomain> productDomainList = Arrays.asList(new ProductDomain(response.getProduct(), response.getEndpoint()));
        Endpoint endpoint = new Endpoint(response.getRegionId(), regionIds, productDomainList);
        endpoints = Arrays.asList(endpoint);
        this.endpointMap.put(product, endpoints);
        return endpoints;
    }

    private DescribeEndpointResponse loadEndpoint(String regionId, String product, Credential credential, LocationConfig locationConfig) throws ClientException {
        DescribeEndpointRequest request = new DescribeEndpointRequest();
        request.setAcceptFormat(FormatType.JSON);
        request.setId(regionId);
        request.setRegionId(locationConfig.getRegionId());
        if (productMap.containsKey(product)) {
            request.setServiceCode(productMap.get(product));
        } else {
            request.setServiceCode(product.toLowerCase());
        }
        ISigner signer = ShaHmac1Singleton.INSTANCE.getInstance();
        ProductDomain domain = new ProductDomain(locationConfig.getProduct(), locationConfig.getEndpoint());
        try {
            HttpRequest httpRequest = request.signRequest(signer, credential, FormatType.JSON, domain);
            HttpResponse httpResponse = HttpResponse.getResponse(httpRequest);
            if (httpResponse.isSuccess()) {
                String data = new String(httpResponse.getContent(), "utf-8");
                DescribeEndpointResponse response = this.getEndpointResponse(data);
                return response;
            }
            AcsError error = this.readError(httpResponse, FormatType.JSON);
            if (500 <= httpResponse.getStatus()) {
                throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
            }
            throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        catch (Exception e) {
            return null;
        }
    }

    private DescribeEndpointResponse getEndpointResponse(String data) throws ClientException {
        Reader reader = ReaderFactory.createInstance(FormatType.JSON);
        UnmarshallerContext context = new UnmarshallerContext();
        DescribeEndpointResponse response = new DescribeEndpointResponse();
        context.setResponseMap(reader.read(data, "DescribeEndpointResponse"));
        response.setRequestId(context.stringValue("DescribeEndpointResponse.RequestId"));
        response.setProduct(context.stringValue("DescribeEndpointResponse.SerivceCode"));
        response.setEndpoint(context.stringValue("DescribeEndpointResponse.Endpoint"));
        response.setRegionId(context.stringValue("DescribeEndpointResponse.Id"));
        return response;
    }

    private AcsError readError(HttpResponse httpResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String responseEndpoint = "Error";
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        String stringContent = this.getResponseContent(httpResponse);
        context.setResponseMap(reader.read(stringContent, responseEndpoint));
        error = error.getInstance(context);
        if (httpResponse.getStatus() > 0) {
            error.setStatusCode(httpResponse.getStatus());
        }
        return error;
    }

    private String getResponseContent(HttpResponse httpResponse) throws ClientException {
        String stringContent = null;
        try {
            stringContent = null == httpResponse.getEncoding() ? new String(httpResponse.getContent()) : new String(httpResponse.getContent(), httpResponse.getEncoding());
        }
        catch (UnsupportedEncodingException exp) {
            throw new ClientException("SDK.UnsupportedEncoding", "Can not parse response due to un supported encoding.");
        }
        return stringContent;
    }

    static {
        productMap.put("", "");
    }
}

