/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ha3engine.vector;

import com.aliyun.darabonba.encode.Encoder;
import com.aliyun.ha3engine.vector.models.Config;
import com.aliyun.ha3engine.vector.models.FetchRequest;
import com.aliyun.ha3engine.vector.models.MultiQueryRequest;
import com.aliyun.ha3engine.vector.models.PushDocumentsRequest;
import com.aliyun.ha3engine.vector.models.PushDocumentsResponse;
import com.aliyun.ha3engine.vector.models.QueryRequest;
import com.aliyun.ha3engine.vector.models.SearchResponse;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tea.interceptor.InterceptorChain;
import com.aliyun.tea.interceptor.RequestInterceptor;
import com.aliyun.tea.interceptor.ResponseInterceptor;
import com.aliyun.tea.interceptor.RuntimeOptionsInterceptor;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.Map;

public class Client {
    private static final InterceptorChain interceptorChain = InterceptorChain.create();
    public String _endpoint;
    public String _instanceId;
    public String _protocol;
    public String _userAgent;
    public String _credential;
    public String _domainsuffix;
    public RuntimeOptions _runtimeOptions;

    public Client(Config config) throws Exception {
        if (Common.isUnset((Object)((Object)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        if (!Common.empty((String)config.accessUserName) && !Common.empty((String)config.accessPassWord)) {
            this._credential = this.getRealmSignStr(config.accessUserName, config.accessPassWord);
        }
        this._endpoint = this.getEndpoint(config.endpoint);
        this._instanceId = config.instanceId;
        this._protocol = config.protocol;
        this._userAgent = config.userAgent;
        this._domainsuffix = "ha.aliyuncs.com";
        this._runtimeOptions = this.buildRuntimeOptions(config.runtimeOptions);
    }

    public Map<String, ?> _request(String method, String pathname, Map<String, ?> query, Map<String, String> headers, Object body, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)runtime.readTimeout), new TeaPair("connectTimeout", (Object)runtime.connectTimeout), new TeaPair("httpsProxy", (Object)runtime.httpsProxy), new TeaPair("noProxy", (Object)runtime.noProxy), new TeaPair("maxIdleConns", (Object)runtime.maxIdleConns), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)runtime.maxAttempts)})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)runtime.backoffPolicy), new TeaPair("period", (Object)runtime.backoffPeriod)})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)"HTTP");
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("user-agent", (Object)this.getUserAgent()), new TeaPair("host", (Object)Common.defaultString((String)this._endpoint, (String)("" + this._instanceId + "." + this._domainsuffix + ""))), new TeaPair("authorization", (Object)("Basic " + this._credential + "")), new TeaPair("content-type", (Object)"application/json; charset=utf-8")}), headers});
                if (!Common.isUnset(query)) {
                    request_.query = Common.stringifyMapValue(query);
                    request_.headers.put("X-Opensearch-Request-ID", Common.getNonce());
                }
                if (!Common.isUnset((Object)body)) {
                    request_.headers.put("X-Opensearch-Swift-Request-ID", Common.getNonce());
                    request_.body = Tea.toReadable((String)Common.toJSONString((Object)body));
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                String objStr = Common.readAsString((InputStream)response_.body);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object rawMsg = null;
                    try {
                        rawMsg = Common.parseJSON((String)objStr);
                    }
                    catch (TeaException err) {
                        rawMsg = objStr;
                    }
                    catch (Exception _err) {
                        TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                        rawMsg = objStr;
                    }
                    Map rawMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("errors", rawMsg)});
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)response_.statusMessage), new TeaPair("data", (Object)rawMap), new TeaPair("code", (Object)response_.statusCode)}));
                }
                if (Common.empty((String)objStr)) {
                    Map rawbodyMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("status", (Object)response_.statusMessage), new TeaPair("code", (Object)response_.statusCode)});
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)Common.toJSONString((Object)rawbodyMap)), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)objStr), new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public void addRuntimeOptionsInterceptor(RuntimeOptionsInterceptor interceptor) {
        interceptorChain.addRuntimeOptionsInterceptor(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        interceptorChain.addRequestInterceptor(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        interceptorChain.addResponseInterceptor(interceptor);
    }

    public String getEndpoint(String endpoint) throws Exception {
        if (com.aliyun.darabonbastring.Client.hasPrefix((String)endpoint, (String)"http://").booleanValue()) {
            return com.aliyun.darabonbastring.Client.replace((String)endpoint, (String)"http://", (String)"", (Integer)1);
        }
        if (com.aliyun.darabonbastring.Client.hasPrefix((String)endpoint, (String)"https://").booleanValue()) {
            return com.aliyun.darabonbastring.Client.replace((String)endpoint, (String)"https://", (String)"", (Integer)1);
        }
        return endpoint;
    }

    public void setUserAgent(String userAgent) throws Exception {
        this._userAgent = userAgent;
    }

    public void appendUserAgent(String userAgent) throws Exception {
        this._userAgent = "" + this._userAgent + " " + userAgent + "";
    }

    public String getUserAgent() throws Exception {
        String userAgent = Common.getUserAgent((String)this._userAgent);
        return userAgent;
    }

    public String getRealmSignStr(String accessUserName, String accessPassWord) throws Exception {
        String accessUserNameStr = com.aliyun.darabonbastring.Client.trim((String)accessUserName);
        String accessPassWordStr = com.aliyun.darabonbastring.Client.trim((String)accessPassWord);
        String realmStr = "" + accessUserNameStr + ":" + accessPassWordStr + "";
        return Encoder.base64EncodeToString((byte[])com.aliyun.darabonbastring.Client.toBytes((String)realmStr, (String)"UTF-8"));
    }

    public SearchResponse query(QueryRequest request) throws Exception {
        return (SearchResponse)TeaModel.toModel(this._request("POST", "/vector-service/query", null, null, Common.toJSONString((Object)((Object)request)), this._runtimeOptions), (TeaModel)new SearchResponse());
    }

    public SearchResponse inferenceQuery(QueryRequest request) throws Exception {
        return (SearchResponse)TeaModel.toModel(this._request("POST", "/vector-service/inference-query", null, null, Common.toJSONString((Object)((Object)request)), this._runtimeOptions), (TeaModel)new SearchResponse());
    }

    public SearchResponse multiQuery(MultiQueryRequest request) throws Exception {
        return (SearchResponse)TeaModel.toModel(this._request("POST", "/vector-service/multi-query", null, null, Common.toJSONString((Object)((Object)request)), this._runtimeOptions), (TeaModel)new SearchResponse());
    }

    public SearchResponse fetch(FetchRequest request) throws Exception {
        return (SearchResponse)TeaModel.toModel(this._request("POST", "/vector-service/fetch", null, null, Common.toJSONString((Object)((Object)request)), this._runtimeOptions), (TeaModel)new SearchResponse());
    }

    public SearchResponse stats(String tableName) throws Exception {
        Map body = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("tableName", (Object)tableName)});
        return (SearchResponse)TeaModel.toModel(this._request("POST", "/vector-service/stats", null, null, Common.toJSONString((Object)body), this._runtimeOptions), (TeaModel)new SearchResponse());
    }

    public PushDocumentsResponse pushDocuments(String dataSourceName, String keyField, PushDocumentsRequest request) throws Exception {
        request.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("X-Opensearch-Swift-PK-Field", (Object)keyField)}), request.headers});
        return (PushDocumentsResponse)TeaModel.toModel(this._request("POST", "/update/" + dataSourceName + "/actions/bulk", null, request.headers, request.body, this._runtimeOptions), (TeaModel)new PushDocumentsResponse());
    }

    public PushDocumentsResponse pushDocumentsWithSwift(String dataSourceName, String keyField, String topic, String swift, PushDocumentsRequest request) throws Exception {
        request.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("X-Opensearch-Swift-PK-Field", (Object)keyField), new TeaPair("X-Opensearch-Swift-Topic", (Object)topic), new TeaPair("X-Opensearch-Swift-Swift", (Object)swift)});
        return (PushDocumentsResponse)TeaModel.toModel(this._request("POST", "/update/" + dataSourceName + "/actions/bulk", null, request.headers, request.body, this._runtimeOptions), (TeaModel)new PushDocumentsResponse());
    }

    public RuntimeOptions buildRuntimeOptions(RuntimeOptions runtimeOptions) throws Exception {
        if (Common.isUnset((Object)runtimeOptions)) {
            return RuntimeOptions.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("readTimeout", (Object)10000), new TeaPair("connectTimeout", (Object)5000), new TeaPair("autoretry", (Object)false), new TeaPair("ignoreSSL", (Object)false), new TeaPair("maxIdleConns", (Object)50)}));
        }
        if (Common.isUnset((Object)runtimeOptions.readTimeout)) {
            runtimeOptions.readTimeout = 10000;
        }
        if (Common.isUnset((Object)runtimeOptions.connectTimeout)) {
            runtimeOptions.connectTimeout = 5000;
        }
        if (Common.isUnset((Object)runtimeOptions.maxIdleConns)) {
            runtimeOptions.maxIdleConns = 50;
        }
        if (Common.isUnset((Object)runtimeOptions.maxAttempts)) {
            runtimeOptions.maxAttempts = 5;
        }
        if (Common.isUnset((Object)runtimeOptions.backoffPolicy)) {
            runtimeOptions.backoffPolicy = "no";
        }
        if (Common.isUnset((Object)runtimeOptions.backoffPeriod)) {
            runtimeOptions.backoffPeriod = 1;
        }
        return runtimeOptions;
    }
}

