/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.exception;

import com.alibaba.cola.exception.BizException;
import com.alibaba.cola.exception.ErrorCodeDefault;
import com.alibaba.cola.exception.ErrorCodeI;
import java.util.Collection;

public abstract class Assert {
    public static void isTrue(boolean expression, ErrorCodeI errorCode, String message) {
        if (!expression) {
            throw new BizException(errorCode, message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        Assert.isTrue(expression, ErrorCodeDefault.BIZ_ERROR, message);
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void notNull(Object object, ErrorCodeI errorCode, String message) {
        if (object == null) {
            throw new BizException(errorCode, message);
        }
    }

    public static void notNull(Object object, String message) {
        Assert.notNull(object, ErrorCodeDefault.BIZ_ERROR, message);
    }

    public static void notNull(Object object) {
        Assert.notNull(object, ErrorCodeDefault.BIZ_ERROR, "[Assertion failed] - the argument " + object + " must not be null");
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (collection != null && collection.size() > 0) {
            throw new BizException(message);
        }
    }
}

