/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials;

import com.aliyun.credentials.AccessKeyCredential;
import com.aliyun.credentials.AlibabaCloudCredentials;
import com.aliyun.credentials.Configuration;
import com.aliyun.credentials.StsCredential;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.DefaultCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RsaKeyPairCredentialProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;

public class Credential {
    private AlibabaCloudCredentials cloudCredential;

    public Credential(Configuration config) throws ParseException, CredentialException, IOException {
        this.cloudCredential = this.getCredential(config);
    }

    public AlibabaCloudCredentials getCredential(Configuration config) throws IOException, CredentialException, ParseException {
        switch (config.getType()) {
            case "access_key": {
                return new AccessKeyCredential(config.getAccessKeyId(), config.getAccessKeySecret());
            }
            case "sts": {
                return new StsCredential(config.getAccessKeyId(), config.getAccessKeySecret(), config.getSecurityToken());
            }
        }
        return this.getProvider(config).getCredentials();
    }

    private AlibabaCloudCredentialsProvider getProvider(Configuration config) throws CredentialException, MalformedURLException {
        try {
            switch (config.getType()) {
                case "ecs_ram_role": {
                    return new EcsRamRoleCredentialProvider(config);
                }
                case "ram_role_arn": {
                    return new RamRoleArnCredentialProvider(config);
                }
                case "rsa_key_pair": {
                    return new RsaKeyPairCredentialProvider(config);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DefaultCredentialsProvider();
    }

    public String getAccessKeyId() {
        return this.cloudCredential.getAccessKeyId();
    }

    public String getAccessKeySecret() {
        return this.cloudCredential.getAccessKeySecret();
    }

    public String getSecurityToken() {
        return this.cloudCredential.getSecurityToken();
    }

    public String getType() {
        return this.cloudCredential.getType();
    }
}

