/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials;

import com.aliyun.credentials.AlibabaCloudCredentials;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;

public class RamRoleArnCredential
implements AlibabaCloudCredentials {
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private long expiration;
    private AlibabaCloudCredentialsProvider provider;

    public RamRoleArnCredential(String accessKeyId, String accessKeySecret, String securityToken, long expiration, AlibabaCloudCredentialsProvider provider) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.expiration = expiration;
        this.provider = provider;
    }

    public boolean withShouldRefresh() {
        return System.currentTimeMillis() >= this.expiration - 180L;
    }

    public RamRoleArnCredential getNewRamRoleArnCredential() {
        try {
            return (RamRoleArnCredential)this.provider.getCredentials();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void refreshCredential() {
        if (this.withShouldRefresh()) {
            RamRoleArnCredential credential = this.getNewRamRoleArnCredential();
            this.expiration = credential.getExpiration();
            this.accessKeyId = credential.getAccessKeyId();
            this.accessKeySecret = credential.getAccessKeySecret();
            this.securityToken = credential.getSecurityToken();
        }
    }

    @Override
    public String getAccessKeyId() {
        this.refreshCredential();
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        this.refreshCredential();
        return this.accessKeySecret;
    }

    @Override
    public String getSecurityToken() {
        this.refreshCredential();
        return this.securityToken;
    }

    @Override
    public String getType() {
        return "ram_role_arn";
    }

    @Override
    public String getBearerToken() {
        return null;
    }

    public long getExpiration() {
        this.refreshCredential();
        return this.expiration;
    }
}

