/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.utils;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AuthUtils {
    private static volatile String clientType = System.getenv("ALIBABA_CLOUD_PROFILE");
    private static volatile String environmentAccessKeyId;
    private static volatile String environmentAccesskeySecret;
    private static volatile String environmentSecurityToken;
    private static volatile String environmentECSMetaData;
    private static volatile Boolean enableECSIMDSv2;
    private static volatile String environmentCredentialsFile;
    private static volatile String environmentRoleArn;
    private static volatile String environmentOIDCProviderArn;
    private static volatile String environmentOIDCTokenFilePath;
    private static volatile String privateKey;
    private static volatile String OIDCToken;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrivateKey(String filePath) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(filePath));
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            privateKey = new String(buffer, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new CredentialException(e.getMessage(), e);
                }
            }
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOIDCToken(String OIDCTokenFilePath) {
        FileInputStream in = null;
        File file = new File(OIDCTokenFilePath);
        if (!file.exists() || !file.isFile()) {
            throw new CredentialException("OIDCTokenFilePath " + OIDCTokenFilePath + " is not exists.");
        }
        if (!file.canRead()) {
            throw new CredentialException("OIDCTokenFilePath " + OIDCTokenFilePath + " cannot be read.");
        }
        try {
            in = new FileInputStream(file);
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            OIDCToken = new String(buffer, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new CredentialException(e.getMessage(), e);
                }
            }
        }
        return OIDCToken;
    }

    public static void setClientType(String clientType) {
        AuthUtils.clientType = clientType;
    }

    public static void setPrivateKey(String key) {
        privateKey = key;
    }

    public static String getClientType() {
        if (null == clientType) {
            clientType = "default";
            return clientType;
        }
        return clientType;
    }

    public static void setEnvironmentAccessKeyId(String environmentAccessKeyId) {
        AuthUtils.environmentAccessKeyId = environmentAccessKeyId;
    }

    public static String getEnvironmentAccessKeyId() {
        return null == environmentAccessKeyId ? System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID") : environmentAccessKeyId;
    }

    public static String getEnvironmentAccessKeySecret() {
        return null == environmentAccesskeySecret ? System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET") : environmentAccesskeySecret;
    }

    public static void setEnvironmentAccessKeySecret(String environmentAccesskeySecret) {
        AuthUtils.environmentAccesskeySecret = environmentAccesskeySecret;
    }

    public static String getEnvironmentSecurityToken() {
        return null == environmentSecurityToken ? System.getenv("ALIBABA_CLOUD_SECURITY_TOKEN") : environmentSecurityToken;
    }

    public static void setEnvironmentSecurityToken(String environmentSecurityToken) {
        AuthUtils.environmentSecurityToken = environmentSecurityToken;
    }

    public static void setEnvironmentECSMetaData(String environmentECSMetaData) {
        AuthUtils.environmentECSMetaData = environmentECSMetaData;
    }

    public static String getEnvironmentECSMetaData() {
        return null == environmentECSMetaData ? System.getenv("ALIBABA_CLOUD_ECS_METADATA") : environmentECSMetaData;
    }

    public static void enableECSIMDSv2(boolean enableECSIMDSv2) {
        AuthUtils.enableECSIMDSv2 = enableECSIMDSv2;
    }

    public static boolean getEnableECSIMDSv2() {
        if (null != enableECSIMDSv2) {
            return enableECSIMDSv2;
        }
        if (null != System.getenv("ALIBABA_CLOUD_ECS_IMDSV2_ENABLE")) {
            return Boolean.parseBoolean(System.getenv("ALIBABA_CLOUD_ECS_IMDSV2_ENABLE"));
        }
        return false;
    }

    public static void setEnvironmentRoleArn(String environmentRoleArn) {
        AuthUtils.environmentRoleArn = environmentRoleArn;
    }

    public static String getEnvironmentRoleArn() {
        return null == environmentRoleArn ? System.getenv("ALIBABA_CLOUD_ROLE_ARN") : environmentRoleArn;
    }

    public static void setEnvironmentOIDCProviderArn(String environmentOIDCProviderArn) {
        AuthUtils.environmentOIDCProviderArn = environmentOIDCProviderArn;
    }

    public static String getEnvironmentOIDCProviderArn() {
        return null == environmentOIDCProviderArn ? System.getenv("ALIBABA_CLOUD_OIDC_PROVIDER_ARN") : environmentOIDCProviderArn;
    }

    public static void setEnvironmentOIDCTokenFilePath(String environmentOIDCTokenFilePath) {
        AuthUtils.environmentOIDCTokenFilePath = environmentOIDCTokenFilePath;
    }

    public static String getEnvironmentOIDCTokenFilePath() {
        return null == environmentOIDCTokenFilePath ? System.getenv("ALIBABA_CLOUD_OIDC_TOKEN_FILE") : environmentOIDCTokenFilePath;
    }

    public static boolean environmentEnableOIDC() {
        return !StringUtils.isEmpty(AuthUtils.getEnvironmentRoleArn()) && !StringUtils.isEmpty(AuthUtils.getEnvironmentOIDCProviderArn()) && !StringUtils.isEmpty(AuthUtils.getEnvironmentOIDCTokenFilePath());
    }

    public static String getEnvironmentCredentialsFile() {
        return null == environmentCredentialsFile ? System.getenv("ALIBABA_CLOUD_CREDENTIALS_FILE") : environmentCredentialsFile;
    }

    public static void setEnvironmentCredentialsFile(String environmentCredentialsFile) {
        AuthUtils.environmentCredentialsFile = environmentCredentialsFile;
    }
}

