package darabonba.core.policy.retry.conditions;


import darabonba.core.policy.retry.RetryUtil;

public final class SdkRetryCondition {

    public static final RetryCondition DEFAULT = OrRetryCondition.create(
            StatusCodeCondition.create(RetryUtil.RETRYABLE_STATUS_CODES),
            ExceptionsCondition.create(RetryUtil.RETRYABLE_EXCEPTIONS)
    );

    public static final RetryCondition NONE = MaxRetriesCondition.create(0);

    private SdkRetryCondition() {
    }
}
