/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry;

import com.aliyun.core.execption.AliyunException;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RetryUtil {
    public static final int TOKEN_BUCKET_SIZE = 500;
    public static final Duration BASE_DELAY = Duration.ofMillis(100L);
    public static final Duration THROTTLED_BASE_DELAY = Duration.ofMillis(500L);
    public static final Duration MAX_BACKOFF = Duration.ofMillis(20000L);
    public static final Integer DEFAULT_MAX_RETRIES = 3;
    private static int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    public static final Set<Integer> RETRYABLE_STATUS_CODES;
    public static final Set<Class<? extends Exception>> RETRYABLE_EXCEPTIONS;

    static {
        HashSet<Integer> retryableStatusCodes = new HashSet<Integer>();
        retryableStatusCodes.add(408);
        retryableStatusCodes.add(HTTP_STATUS_TOO_MANY_REQUESTS);
        retryableStatusCodes.add(500);
        retryableStatusCodes.add(502);
        retryableStatusCodes.add(503);
        retryableStatusCodes.add(504);
        RETRYABLE_STATUS_CODES = Collections.unmodifiableSet(retryableStatusCodes);
        HashSet<Class> retryableExceptions = new HashSet<Class>();
        retryableExceptions.add(AliyunException.class);
        retryableExceptions.add(IOException.class);
        RETRYABLE_EXCEPTIONS = Collections.unmodifiableSet(retryableExceptions);
    }
}

