/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core;

import darabonba.core.RequestConfiguration;
import darabonba.core.TeaModel;
import darabonba.core.utils.CommonUtil;
import darabonba.core.utils.ModelUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class RequestModel
extends TeaModel {
    private final Map<String, Object> queryParameters;
    private final Map<String, Object> bodyParameters;
    private final Map<String, String> hostParameters;
    private final Map<String, String> pathParameters;
    private final Map<String, Object> headerParameters;
    private final RequestConfiguration requestConfiguration;

    protected RequestModel(BuilderImpl<?, ?> builder) {
        this.queryParameters = ((BuilderImpl)builder).queryParameters;
        this.bodyParameters = ((BuilderImpl)builder).bodyParameters != null && !((BuilderImpl)builder).bodyParameters.isEmpty() ? ((BuilderImpl)builder).bodyParameters : null;
        this.hostParameters = ((BuilderImpl)builder).hostParameters;
        this.pathParameters = ((BuilderImpl)builder).pathParameters;
        this.headerParameters = ((BuilderImpl)builder).headerParameters;
        this.requestConfiguration = ((BuilderImpl)builder).requestConfiguration;
    }

    public RequestConfiguration getRequestConfiguration() {
        return this.requestConfiguration;
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, Object> getBodyParameters() {
        return this.bodyParameters;
    }

    public Map<String, String> getHostParameters() {
        return this.hostParameters;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, Object> getHeaderParameters() {
        return this.headerParameters;
    }

    protected static abstract class BuilderImpl<ProviderT extends RequestModel, BuilderT extends Builder>
    implements Builder<ProviderT, BuilderT> {
        private Map<String, Object> queryParameters = new HashMap<String, Object>();
        private Map<String, Object> bodyParameters = new HashMap<String, Object>();
        private Map<String, String> hostParameters = new HashMap<String, String>();
        private Map<String, String> pathParameters = new HashMap<String, String>();
        private Map<String, Object> headerParameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        private RequestConfiguration requestConfiguration;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RequestModel requestModel) {
            this.queryParameters = requestModel.queryParameters;
            this.bodyParameters = requestModel.bodyParameters;
            this.hostParameters = requestModel.hostParameters;
            this.pathParameters = requestModel.pathParameters;
            this.headerParameters = requestModel.headerParameters;
            this.requestConfiguration = requestModel.requestConfiguration;
        }

        @Override
        public BuilderT requestConfiguration(RequestConfiguration requestConfiguration) {
            this.requestConfiguration = requestConfiguration;
            return (BuilderT)this;
        }

        protected void putQueryParameter(String name, Object value) {
            if (!CommonUtil.isUnset(name)) {
                this.queryParameters.put(name, value);
            }
        }

        protected void putBodyParameter(String name, Object value) {
            if (!CommonUtil.isUnset(name)) {
                this.bodyParameters.put(name, value);
            }
        }

        protected void putHostParameter(String name, Object value) {
            if (!CommonUtil.isUnset(name)) {
                this.hostParameters.put(name, String.valueOf(value));
            }
        }

        protected void putPathParameter(String name, Object value) {
            if (!CommonUtil.isUnset(name)) {
                this.pathParameters.put(name, String.valueOf(value));
            }
        }

        protected void putHeaderParameter(String name, Object value) {
            if (!CommonUtil.isUnset(name)) {
                this.headerParameters.put(name, value);
            }
        }

        protected String shrink(Object o, String prefix, String style) {
            return ModelUtil.shrinkSpecifiedStyle(o, prefix, style);
        }
    }

    public static interface Builder<ProviderT extends RequestModel, BuilderT extends Builder> {
        public BuilderT requestConfiguration(RequestConfiguration var1);

        public ProviderT build();
    }
}

