package darabonba.core.sse;

import com.aliyun.core.utils.StringUtils;
import darabonba.core.ResponseIterator;
import darabonba.core.exception.TeaException;

import java.util.*;

public abstract class SSEResponseIterator<T> extends ResponseIterator<T> {
    private volatile int retry = 3000;
    private volatile boolean endOfEvent = false;
    private final Queue<T> events = new LinkedList<>();
    private final List<T> backoff = new ArrayList<>();
//    private final List<Event> eventList = new ArrayList<>();
    private java.util.Map<String, String> headers;
    private Integer statusCode;
    private volatile boolean endOfFailure = false;
    private volatile Throwable throwable;

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw (E) e;
    }

    @Override
    public boolean hasNext() {
        while (this.events.isEmpty() && !this.endOfEvent && !isEndOfFailure()) {
            try {
                Thread.sleep(this.retry);
            } catch (InterruptedException e) {
                throw new TeaException(e);
            }
        }
        if (isEndOfFailure()) {
            sneakyThrow(getThrowable());
        }
        return !this.events.isEmpty() || !this.endOfEvent;
    }

    @Override
    public T next() {
        return this.events.poll();
    }

    public void addEvent(Event event) {
//        this.eventList.add(event);
        if (event.getRetry() > 0) {
            this.retry = event.getRetry();
        }
        String data = event.getData();
        if (!StringUtils.isEmpty(data)) {
            T model = toModel(data);
            this.events.add(model);
            this.backoff.add(model);
        }
    }

    @Override
    public List<T> getAll() {
        return this.backoff;
    }

//    public List<Event> getEvents() {
//        return this.eventList;
//    }

    abstract protected T toModel(String data);

    protected void endOfEvent() {
        this.endOfEvent = true;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public Integer getStatusCode() {
        return statusCode;
    }

    protected void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    protected void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    protected void endOfFailure(Throwable throwable) {
        this.endOfFailure = true;
        this.throwable = throwable;
    }

    protected boolean isEndOfFailure() {
        return endOfFailure;
    }

    protected Throwable getThrowable() {
        return throwable;
    }
}
