/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.DefaultMNSClient;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.client.Utils;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.common.http.HttpCallback;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.http.ServiceClientFactory;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import java.util.concurrent.ExecutorService;
import shaded.org.apache.commons.logging.Log;
import shaded.org.apache.commons.logging.LogFactory;

public final class CloudAccount {
    private static Log log = LogFactory.getLog(CloudAccount.class);
    private String accessId;
    private String accessKey;
    private String securityToken;
    private String accountEndpoint;
    private AlibabaCloudCredentialsProvider credentialsProvider;
    private ServiceClient serviceClient = null;
    private ServiceCredentials credentials = new ServiceCredentials();
    private ClientConfiguration config;
    private MNSClient mnsClient;

    public static void setCallbackExecutor(ExecutorService executor) {
        HttpCallback.setCallbackExecutor(executor);
    }

    public CloudAccount(String accessId, String accessKey, String accountEndpoint) {
        this(accessId, accessKey, accountEndpoint, "", null, null);
    }

    public CloudAccount(String accessId, String accessKey, String accountEndpoint, String securityToken) {
        this(accessId, accessKey, accountEndpoint, securityToken, null, null);
    }

    public CloudAccount(String accessId, String accessKey, String accountEndpoint, ClientConfiguration config) {
        this(accessId, accessKey, accountEndpoint, "", null, config);
    }

    public CloudAccount(String accountEndpoint, AlibabaCloudCredentialsProvider provider) {
        this(null, null, accountEndpoint, null, provider, null);
    }

    public CloudAccount(String accountEndpoint, AlibabaCloudCredentialsProvider provider, ClientConfiguration config) {
        this(null, null, accountEndpoint, null, provider, config);
    }

    public CloudAccount(String accessId, String accessKey, String accountEndpoint, AlibabaCloudCredentialsProvider provider) {
        this(accessId, accessKey, accountEndpoint, "", provider, null);
    }

    public CloudAccount(String accessId, String accessKey, String accountEndpoint, String securityToken, AlibabaCloudCredentialsProvider provider) {
        this(accessId, accessKey, accountEndpoint, securityToken, provider, null);
    }

    public CloudAccount(String accessId, String accessKey, String accountEndpoint, String securityToken, AlibabaCloudCredentialsProvider provider, ClientConfiguration config) {
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.accountEndpoint = Utils.getHttpURI(accountEndpoint).toString();
        this.securityToken = securityToken;
        this.credentialsProvider = provider;
        this.config = config;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MNSClient getMNSClient() throws ServiceException, ClientException {
        if (this.mnsClient == null) {
            CloudAccount cloudAccount = this;
            synchronized (cloudAccount) {
                if (this.mnsClient == null) {
                    String accountEndpoint = this.getAccountEndpoint();
                    try {
                        this.serviceClient = ServiceClientFactory.createServiceClient(this.config);
                        this.mnsClient = new DefaultMNSClient(this.credentials, this.serviceClient, accountEndpoint);
                    }
                    catch (Exception e) {
                        if (this.serviceClient != null) {
                            ServiceClientFactory.closeServiceClient(this.serviceClient);
                            this.serviceClient = null;
                        }
                        throw new ClientException(e);
                    }
                }
            }
        }
        return this.mnsClient;
    }

    private void init() {
        this.credentials = this.accessId != null && this.accessKey != null ? new ServiceCredentials(this.accessId, this.accessKey, this.securityToken) : new ServiceCredentials(this.credentialsProvider);
        if (this.config == null) {
            this.config = new ClientConfiguration();
        }
        if (log.isDebugEnabled()) {
            log.debug("initiated CloudAccount, accessId=" + this.accessId + ",accessKey=" + this.accessKey + ", endpoint=" + this.accountEndpoint + " securityToken=" + this.securityToken);
        }
    }

    public String getAccountEndpoint() {
        return this.accountEndpoint;
    }

    public void setAccountEndpoint(String endpoint) {
        this.accountEndpoint = Utils.getHttpURI(endpoint).toString();
    }
}

