/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.topic;

import com.aliyun.mns.common.utils.BooleanSerializer;
import com.aliyun.mns.model.MessageAttributes;
import com.aliyun.mns.model.PushAttributes;
import com.aliyun.mns.model.TopicMessage;
import com.aliyun.mns.model.request.topic.PublishMessageRequest;
import com.aliyun.mns.model.serialize.XMLSerializer;
import com.aliyun.mns.model.serialize.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import shaded.com.google.gson.FieldNamingPolicy;
import shaded.com.google.gson.Gson;
import shaded.com.google.gson.GsonBuilder;

public class TopicMessageSerializer
extends XMLSerializer<PublishMessageRequest> {
    private static Gson gson = null;

    private synchronized Gson getGson() {
        if (gson == null) {
            GsonBuilder b = new GsonBuilder();
            b.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
            BooleanSerializer serializer = new BooleanSerializer();
            b.registerTypeAdapter((Type)((Object)Boolean.class), serializer);
            b.registerTypeAdapter(Boolean.TYPE, serializer);
            b.registerTypeAdapter((Type)((Object)PushAttributes.class), new PushAttributes.PushAttributesSerializer());
            gson = b.create();
        }
        return gson;
    }

    @Override
    public InputStream serialize(PublishMessageRequest request, String encoding) throws Exception {
        MessageAttributes messageAttributes;
        Document doc = this.getDocmentBuilder().newDocument();
        TopicMessage msg = request.getMessage();
        Element root = doc.createElementNS("http://mns.aliyuncs.com/doc/v1", "Message");
        doc.appendChild(root);
        Element node = this.safeCreateContentElement(doc, "MessageBody", msg.getMessageBody(), "");
        if (node != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreateContentElement(doc, "MessageTag", msg.getMessageTag(), null)) != null) {
            root.appendChild(node);
        }
        if ((messageAttributes = request.getMessageAttributes()) != null) {
            Element attributesNode = doc.createElement("MessageAttributes");
            root.appendChild(attributesNode);
            if (messageAttributes.getMailAttributes() != null && (node = this.safeCreateContentElement(doc, "DirectMail", messageAttributes.getMailAttributes().toJson(this.getGson()), null)) != null) {
                attributesNode.appendChild(node);
            }
            if (messageAttributes.getDayuAttributes() != null && (node = this.safeCreateContentElement(doc, "Dayu", messageAttributes.getDayuAttributes().toJson(this.getGson()), null)) != null) {
                attributesNode.appendChild(node);
            }
            if (messageAttributes.getSmsAttributes() != null && (node = this.safeCreateContentElement(doc, "DirectSMS", messageAttributes.getSmsAttributes().toJson(this.getGson()), null)) != null) {
                attributesNode.appendChild(node);
            }
            if (messageAttributes.getBatchSmsAttributes() != null && (node = this.safeCreateContentElement(doc, "DirectSMS", messageAttributes.getBatchSmsAttributes().toJson(this.getGson()), null)) != null) {
                attributesNode.appendChild(node);
            }
            if (messageAttributes.getWebSocketAttributes() != null && (node = this.safeCreateContentElement(doc, "WebSocket", messageAttributes.getWebSocketAttributes().toJson(this.getGson()), null)) != null) {
                attributesNode.appendChild(node);
            }
            if (messageAttributes.getPushAttributes() != null && (node = this.safeCreateContentElement(doc, "Push", messageAttributes.getPushAttributes().toJson(this.getGson()), null)) != null) {
                attributesNode.appendChild(node);
            }
        }
        String xml = XmlUtil.xmlNodeToString(doc, encoding);
        return new ByteArrayInputStream(xml.getBytes(encoding));
    }
}

