/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.sample;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.codec.binary.Base64;
import shaded.org.apache.commons.logging.Log;
import shaded.org.apache.commons.logging.LogFactory;
import shaded.org.apache.http.ConnectionClosedException;
import shaded.org.apache.http.Header;
import shaded.org.apache.http.HttpConnectionFactory;
import shaded.org.apache.http.HttpEntity;
import shaded.org.apache.http.HttpEntityEnclosingRequest;
import shaded.org.apache.http.HttpException;
import shaded.org.apache.http.HttpRequest;
import shaded.org.apache.http.HttpResponse;
import shaded.org.apache.http.HttpServerConnection;
import shaded.org.apache.http.MethodNotSupportedException;
import shaded.org.apache.http.impl.DefaultBHttpServerConnection;
import shaded.org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import shaded.org.apache.http.protocol.BasicHttpContext;
import shaded.org.apache.http.protocol.HttpContext;
import shaded.org.apache.http.protocol.HttpProcessor;
import shaded.org.apache.http.protocol.HttpProcessorBuilder;
import shaded.org.apache.http.protocol.HttpRequestHandler;
import shaded.org.apache.http.protocol.HttpService;
import shaded.org.apache.http.protocol.ResponseConnControl;
import shaded.org.apache.http.protocol.ResponseContent;
import shaded.org.apache.http.protocol.ResponseDate;
import shaded.org.apache.http.protocol.ResponseServer;
import shaded.org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class HttpEndpoint {
    public static Log logger = LogFactory.getLog(HttpEndpoint.class);
    public static Thread t;
    private int port;

    public static String GenEndpointLocal() {
        return HttpEndpoint.GenEndpointLocal(80);
    }

    public static String GenEndpointLocal(int port) {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String ip = addr.getHostAddress().toString();
            return "http://" + ip + ":" + port;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            logger.warn("get local host fail," + e.getMessage());
            return "http://127.0.0.1:" + port;
        }
    }

    public HttpEndpoint(int port) {
        this.init(port);
    }

    public HttpEndpoint() {
        this.init(80);
    }

    private void init(int port) {
        this.port = port;
        t = null;
    }

    public void start() throws Exception {
        try {
            new Socket(InetAddress.getLocalHost(), this.port);
            System.out.println("port is used!");
            logger.error("port already in use, http server start failed");
            throw new BindException("port already in use");
        }
        catch (IOException iOException) {
            HttpProcessor httpproc = HttpProcessorBuilder.create().add(new ResponseDate()).add(new ResponseServer("MNS-Endpoint/1.1")).add(new ResponseContent()).add(new ResponseConnControl()).build();
            UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
            reqistry.register("/notifications", new NSHandler());
            reqistry.register("/simplified", new SimplifiedNSHandler());
            HttpService httpService = new HttpService(httpproc, reqistry);
            t = new RequestListenerThread(this.port, httpService, null);
            t.setDaemon(false);
            t.start();
            return;
        }
    }

    public void stop() {
        if (t != null) {
            t.interrupt();
            try {
                t.join(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("endpoint stop");
    }

    private Boolean authenticate(String method, String uri, Map<String, String> headers, String cert) {
        String str2sign = this.getSignStr(method, uri, headers);
        String signature = headers.get("Authorization");
        byte[] decodedSign = Base64.decodeBase64(signature);
        try {
            URL url = new URL(cert);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            DataInputStream in = new DataInputStream(conn.getInputStream());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate c = cf.generateCertificate(in);
            PublicKey pk = c.getPublicKey();
            Signature signetcheck = Signature.getInstance("SHA1withRSA");
            signetcheck.initVerify(pk);
            signetcheck.update(str2sign.getBytes());
            Boolean res = signetcheck.verify(decodedSign);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("authenticate fail, " + e.getMessage());
            return false;
        }
    }

    private String getSignStr(String method, String uri, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        sb.append(method);
        sb.append("\n");
        sb.append(this.safeGetHeader(headers, "Content-md5"));
        sb.append("\n");
        sb.append(this.safeGetHeader(headers, "Content-Type"));
        sb.append("\n");
        sb.append(this.safeGetHeader(headers, "Date"));
        sb.append("\n");
        ArrayList<String> tmp = new ArrayList<String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (!entry.getKey().startsWith("x-mns-")) continue;
            tmp.add(entry.getKey() + ":" + entry.getValue());
        }
        Collections.sort(tmp);
        for (String kv : tmp) {
            sb.append(kv);
            sb.append("\n");
        }
        sb.append(uri);
        return sb.toString();
    }

    private String safeGetHeader(Map<String, String> headers, String name) {
        if (headers.containsKey(name)) {
            return headers.get(name);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int port = 8080;
        HttpEndpoint httpEndpoint = null;
        try {
            httpEndpoint = new HttpEndpoint(port);
            httpEndpoint.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            httpEndpoint.stop();
        }
    }

    public class WorkerThread
    extends Thread {
        private final HttpService httpservice;
        private final HttpServerConnection conn;

        public WorkerThread(HttpService httpservice, HttpServerConnection conn) {
            this.httpservice = httpservice;
            this.conn = conn;
        }

        @Override
        public void run() {
            System.out.println("New connection thread");
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (!Thread.interrupted() && this.conn.isOpen()) {
                    this.httpservice.handleRequest(this.conn, context);
                }
            }
            catch (ConnectionClosedException ex) {
                System.err.println("Client closed connection");
            }
            catch (IOException ex) {
                System.err.println("I/O error: " + ex.getMessage());
            }
            catch (HttpException ex) {
                System.err.println("Unrecoverable HTTP protocol violation: " + ex.getMessage());
            }
            finally {
                try {
                    this.conn.shutdown();
                }
                catch (IOException ex) {}
            }
        }
    }

    public class RequestListenerThread
    extends Thread {
        private final HttpConnectionFactory<DefaultBHttpServerConnection> connFactory = DefaultBHttpServerConnectionFactory.INSTANCE;
        private final ServerSocket serversocket;
        private final HttpService httpService;

        public RequestListenerThread(int port, HttpService httpService, SSLServerSocketFactory sf) throws IOException {
            this.serversocket = sf != null ? sf.createServerSocket(port) : new ServerSocket(port);
            this.httpService = httpService;
        }

        @Override
        public void run() {
            System.out.println("Listening on port " + this.serversocket.getLocalPort());
            Thread t = null;
            while (!Thread.interrupted()) {
                try {
                    Socket socket = this.serversocket.accept();
                    System.out.println("Incoming connection from " + socket.getInetAddress());
                    HttpServerConnection conn = this.connFactory.createConnection(socket);
                    t = new WorkerThread(this.httpService, conn);
                    t.setDaemon(true);
                    t.start();
                }
                catch (IOException e) {
                    System.err.println("Endpoint http server stop or IO error: " + e.getMessage());
                    try {
                        if (t == null) break;
                        t.join(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            try {
                this.serversocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class NSHandler
    implements HttpRequestHandler {
        public Log logger = LogFactory.getLog(HttpRequestHandler.class);

        private String safeGetElementContent(Element element, String tag) {
            NodeList nl = element.getElementsByTagName(tag);
            if (nl != null && nl.getLength() > 0) {
                return nl.item(0).getTextContent();
            }
            this.logger.warn("get " + tag + " from xml fail");
            return "";
        }

        private void paserContent(Element notify) {
            try {
                String topicOwner = this.safeGetElementContent(notify, "TopicOwner");
                System.out.println("TopicOwner:\t" + topicOwner);
                this.logger.debug("TopicOwner:\t" + topicOwner);
                String topicName = this.safeGetElementContent(notify, "TopicName");
                System.out.println("TopicName:\t" + topicName);
                this.logger.debug("TopicName:\t" + topicName);
                String subscriber = this.safeGetElementContent(notify, "Subscriber");
                System.out.println("Subscriber:\t" + subscriber);
                this.logger.debug("Subscriber:\t" + subscriber);
                String subscriptionName = this.safeGetElementContent(notify, "SubscriptionName");
                System.out.println("SubscriptionName:\t" + subscriptionName);
                this.logger.debug("SubscriptionName:\t" + subscriptionName);
                String msgid = this.safeGetElementContent(notify, "MessageId");
                System.out.println("MessageId:\t" + msgid);
                this.logger.debug("MessageId:\t" + msgid);
                String msg = this.safeGetElementContent(notify, "Message");
                System.out.println("Message:\t" + new String(Base64.decodeBase64(msg)));
                this.logger.debug("Message:\t" + new String(Base64.decodeBase64(msg)));
                String msgMD5 = this.safeGetElementContent(notify, "MessageMD5");
                System.out.println("MessageMD5:\t" + msgMD5);
                this.logger.debug("MessageMD5:\t" + msgMD5);
                String msgPublishTime = this.safeGetElementContent(notify, "PublishTime");
                Date d = new Date(Long.parseLong(msgPublishTime));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String strdate = sdf.format(d);
                System.out.println("PublishTime:\t" + strdate);
                this.logger.debug("MessagePublishTime:\t" + strdate);
                String msgTag = this.safeGetElementContent(notify, "MessageTag");
                if (msgTag != "") {
                    System.out.println("MessageTag:\t" + msgTag);
                    this.logger.debug("MessageTag:\t" + msgTag);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                this.logger.warn(e.getMessage());
            }
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            Header[] headers = request.getAllHeaders();
            HashMap<String, String> hm = new HashMap<String, String>();
            for (Header h : headers) {
                System.out.println(h.getName() + ":" + h.getValue());
                hm.put(h.getName(), h.getValue());
            }
            String target = request.getRequestLine().getUri();
            System.out.println(target);
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                InputStream content = entity.getContent();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                Element notify = null;
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document document = db.parse(content);
                    NodeList nl = document.getElementsByTagName("Notification");
                    if (nl == null || nl.getLength() == 0) {
                        System.out.println("xml tag error");
                        this.logger.warn("xml tag error");
                        response.setStatusCode(400);
                        return;
                    }
                    notify = (Element)nl.item(0);
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    this.logger.warn("xml parser fail! " + e.getMessage());
                    response.setStatusCode(400);
                    return;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    this.logger.warn("xml parser fail! " + e.getMessage());
                    response.setStatusCode(400);
                    return;
                }
                Header certHeader = request.getFirstHeader("x-mns-signing-cert-url");
                if (certHeader == null) {
                    System.out.println("SigningCerURL Header not found");
                    response.setStatusCode(400);
                    return;
                }
                String cert = certHeader.getValue();
                if (cert.isEmpty()) {
                    System.out.println("SigningCertURL empty");
                    response.setStatusCode(400);
                    return;
                }
                cert = new String(Base64.decodeBase64(cert));
                System.out.println("SigningCertURL:\t" + cert);
                this.logger.debug("SigningCertURL:\t" + cert);
                if (!HttpEndpoint.this.authenticate(method, target, hm, cert).booleanValue()) {
                    System.out.println("authenticate fail");
                    this.logger.warn("authenticate fail");
                    response.setStatusCode(400);
                    return;
                }
                this.paserContent(notify);
            }
            response.setStatusCode(204);
        }
    }

    public class SimplifiedNSHandler
    implements HttpRequestHandler {
        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            Header[] headers = request.getAllHeaders();
            HashMap<String, String> hm = new HashMap<String, String>();
            for (Header h : headers) {
                System.out.println(h.getName() + ":" + h.getValue());
                hm.put(h.getName(), h.getValue());
            }
            String target = request.getRequestLine().getUri();
            System.out.println(target);
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                Header certHeader = request.getFirstHeader("x-mns-signing-cert-url");
                if (certHeader == null) {
                    System.out.println("SigningCerURL Header not found");
                    response.setStatusCode(400);
                    return;
                }
                String cert = certHeader.getValue();
                if (cert.isEmpty()) {
                    System.out.println("SigningCertURL empty");
                    response.setStatusCode(400);
                    return;
                }
                cert = new String(Base64.decodeBase64(cert));
                System.out.println("SigningCertURL:\t" + cert);
                logger.debug("SigningCertURL:\t" + cert);
                if (!HttpEndpoint.this.authenticate(method, target, hm, cert).booleanValue()) {
                    System.out.println("authenticate fail");
                    logger.warn("authenticate fail");
                    response.setStatusCode(400);
                    return;
                }
                InputStream is = entity.getContent();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                }
                String content = buffer.toString();
                System.out.println("Simplified Notification: \n" + content);
            }
            response.setStatusCode(204);
        }
    }
}

