/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client.impl.commonbuy;

import com.aliyun.mns.client.impl.AbstractAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.model.request.commonbuy.OpenServiceRequest;
import com.aliyun.mns.model.response.commonbuy.OpenServiceResponse;
import com.aliyun.mns.model.serialize.commonbuy.OpenServiceResponseDeserializer;
import java.net.URI;

public class OpenServiceAction
extends AbstractAction<OpenServiceRequest, OpenServiceResponse> {
    public OpenServiceAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.POST, "OpenService", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(OpenServiceRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath());
        return requestMessage;
    }

    @Override
    protected ResultParser<OpenServiceResponse> buildResultParser() {
        return new ResultParser<OpenServiceResponse>(){

            @Override
            public OpenServiceResponse parse(ResponseMessage response) throws ResultParseException {
                OpenServiceResponseDeserializer deserializer = new OpenServiceResponseDeserializer();
                try {
                    OpenServiceResponse resp = deserializer.deserialize(response.getContent());
                    resp.setRequestId(response.getHeader("x-mns-request-id"));
                    return resp;
                }
                catch (Exception e) {
                    AbstractAction.logger.warn("Unmarshal error,cause by:" + e.getMessage());
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

