/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.topic;

import com.aliyun.mns.common.utils.BooleanSerializer;
import com.aliyun.mns.model.BaseAttributes;
import com.aliyun.mns.model.MessageAttributes;
import com.aliyun.mns.model.PushAttributes;
import com.aliyun.mns.model.TopicMessage;
import com.aliyun.mns.model.request.topic.PublishMessageRequest;
import com.aliyun.mns.model.serialize.XMLSerializer;
import com.aliyun.mns.model.serialize.XmlUtil;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopicMessageSerializer
extends XMLSerializer<PublishMessageRequest> {
    private static Gson gson = null;

    private synchronized Gson getGson() {
        if (gson == null) {
            GsonBuilder b = new GsonBuilder();
            b.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
            BooleanSerializer serializer = new BooleanSerializer();
            b.registerTypeAdapter(Boolean.class, (Object)serializer);
            b.registerTypeAdapter(Boolean.TYPE, (Object)serializer);
            b.registerTypeAdapter(PushAttributes.class, (Object)new PushAttributes.PushAttributesSerializer());
            gson = b.create();
        }
        return gson;
    }

    @Override
    public InputStream serialize(PublishMessageRequest request, String encoding) throws Exception {
        MessageAttributes messageAttributes;
        Document doc = this.getDocumentBuilder().newDocument();
        TopicMessage msg = request.getMessage();
        Element root = doc.createElementNS("http://mns.aliyuncs.com/doc/v1", "Message");
        doc.appendChild(root);
        Element node = this.safeCreateContentElement(doc, "MessageBody", msg.getOriginalMessageBody(), "");
        if (node != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreateContentElement(doc, "MessageTag", msg.getMessageTag(), null)) != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreatePropertiesNode(doc, msg.getUserProperties(), "UserProperties", "PropertyValue")) != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreatePropertiesNode(doc, msg.getSystemProperties(), "SystemProperties", "SystemPropertyValue")) != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreateContentElement(doc, "MessageGroupId", msg.getMessageGroupId(), null)) != null) {
            root.appendChild(node);
        }
        if ((messageAttributes = request.getMessageAttributes()) != null) {
            Element attributesNode = doc.createElement("MessageAttributes");
            root.appendChild(attributesNode);
            this.appendAttributeElement(doc, attributesNode, "DirectMail", messageAttributes.getMailAttributes());
            this.appendAttributeElement(doc, attributesNode, "Dayu", messageAttributes.getDayuAttributes());
            this.appendAttributeElement(doc, attributesNode, "DirectSMS", messageAttributes.getSmsAttributes());
            this.appendAttributeElement(doc, attributesNode, "DirectSMS", messageAttributes.getBatchSmsAttributes());
            this.appendAttributeElement(doc, attributesNode, "WebSocket", messageAttributes.getWebSocketAttributes());
            this.appendAttributeElement(doc, attributesNode, "Push", messageAttributes.getPushAttributes());
            this.appendAttributeElement(doc, attributesNode, "DYSMS", messageAttributes.getDysmsAttributes());
            this.appendAttributeElement(doc, attributesNode, "DM", messageAttributes.getDmAttributes());
        }
        String xml = XmlUtil.xmlNodeToString(doc, encoding);
        return new ByteArrayInputStream(xml.getBytes(encoding));
    }

    private void appendAttributeElement(Document doc, Element parent, String tag, BaseAttributes attributes) {
        Element node;
        if (attributes != null && (node = this.safeCreateContentElement(doc, tag, attributes.toJson(this.getGson()), null)) != null) {
            parent.appendChild(node);
        }
    }
}

