/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.JdbcColumn;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OdpsResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final List<String> columnNames;
    private final List<OdpsType> columnTypes;
    private Map<String, Integer> nameIndexMap;
    private String catalogName = " ";
    private String schemeName = " ";
    private String tableName = " ";

    OdpsResultSetMetaData(List<String> columnNames, List<OdpsType> columnTypes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.catalogName;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.columnClassName(type);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.columnDisplaySize(type);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.OdpsTypeToSqlType(type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return OdpsType.getFullTypeString((OdpsType)type, null);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.columnPrecision(type);
    }

    @Override
    public int getScale(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.columnScale(type);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.schemeName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.columnCaseSensitive(type);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        OdpsType type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.columnSigned(type);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setSchemeName(String scheme) {
        this.schemeName = scheme;
    }

    public void setCatalogName(String catalog) {
        this.catalogName = catalog;
    }

    public int getColumnIndex(String name) {
        Integer index;
        if (this.nameIndexMap == null) {
            this.nameIndexMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.columnNames.size(); ++i) {
                this.nameIndexMap.put(this.columnNames.get(i), i + 1);
                this.nameIndexMap.put(this.columnNames.get(i).toLowerCase(), i + 1);
            }
        }
        if ((index = this.nameIndexMap.get(name)) == null) {
            String lowerName = name.toLowerCase();
            if (lowerName.equals(name)) {
                return -1;
            }
            index = this.nameIndexMap.get(name);
        }
        if (index == null) {
            return -1;
        }
        return index;
    }

    protected int toZeroIndex(int column) {
        if (column <= 0 || column > this.columnNames.size()) {
            throw new IllegalArgumentException();
        }
        return column - 1;
    }
}

