/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import java.util.HashMap;
import java.util.Properties;

public class ConnectionResource {
    private static final String JDBC_ODPS_URL_PREFIX = "jdbc:odps:";
    private static final String CHARSET_DEFAULT_VALUE = "UTF-8";
    private static final String LIFECYCLE_DEFAULT_VALUE = "3";
    private static final String LOGLEVEL_DEFAULT_VALUE = "INFO";
    private static final String ACCESS_ID_URL_KEY = "accessId";
    private static final String ACCESS_KEY_URL_KEY = "accessKey";
    private static final String PROJECT_URL_KEY = "project";
    private static final String CHARSET_URL_KEY = "charset";
    private static final String LOGVIEW_URL_KEY = "logview";
    private static final String LIFECYCLE_URL_KEY = "lifecycle";
    private static final String LOGLEVEL_URL_KEY = "loglevel";
    public static final String ACCESS_ID_PROP_KEY = "access_id";
    public static final String ACCESS_KEY_PROP_KEY = "access_key";
    public static final String PROJECT_PROP_KEY = "project_name";
    public static final String CHARSET_PROP_KEY = "charset";
    public static final String LOGVIEW_HOST_PROP_KEY = "logview_host";
    public static final String LIFECYCLE_PROP_KEY = "lifecycle";
    public static final String LOGLEVEL_PROP_KEY = "log_level";
    private static final String ACCESS_ID_PROP_KEY_ALT = "user";
    private static final String ACCESS_KEY_PROP_KEY_ALT = "password";
    private String endpoint;
    private String accessId;
    private String accessKey;
    private String project;
    private String charset = "UTF-8";
    private String logview;
    private String lifecycle = "3";
    private String logLevel = "INFO";

    public static boolean acceptURL(String url) {
        return url != null && url.startsWith(JDBC_ODPS_URL_PREFIX);
    }

    public ConnectionResource(String url, Properties info) {
        HashMap<String, String> paramsInURL = new HashMap<String, String>();
        url = url.substring(JDBC_ODPS_URL_PREFIX.length());
        int atPos = url.indexOf("?");
        if (atPos == -1) {
            this.endpoint = url;
        } else {
            String[] pairs;
            this.endpoint = url.substring(0, atPos);
            String query = url.substring(atPos + 1);
            for (String pair : pairs = query.split("&")) {
                String[] keyvalue = pair.split("=");
                paramsInURL.put(keyvalue[0], keyvalue[1]);
            }
            if (paramsInURL.get(ACCESS_ID_URL_KEY) != null) {
                this.accessId = (String)paramsInURL.get(ACCESS_ID_URL_KEY);
            }
            if (paramsInURL.get(ACCESS_KEY_URL_KEY) != null) {
                this.accessKey = (String)paramsInURL.get(ACCESS_KEY_URL_KEY);
            }
            if (paramsInURL.get("charset") != null) {
                this.charset = (String)paramsInURL.get("charset");
            }
            if (paramsInURL.get(PROJECT_URL_KEY) != null) {
                this.project = (String)paramsInURL.get(PROJECT_URL_KEY);
            }
            if (paramsInURL.get(LOGVIEW_URL_KEY) != null) {
                this.logview = (String)paramsInURL.get(LOGVIEW_URL_KEY);
            }
            if (paramsInURL.get("lifecycle") != null) {
                this.lifecycle = (String)paramsInURL.get("lifecycle");
            }
            if (paramsInURL.get(LOGLEVEL_URL_KEY) != null) {
                this.logLevel = (String)paramsInURL.get(LOGLEVEL_URL_KEY);
            }
        }
        if (info != null) {
            if (info.getProperty(ACCESS_ID_PROP_KEY) != null) {
                this.accessId = info.getProperty(ACCESS_ID_PROP_KEY);
            } else if (info.getProperty(ACCESS_ID_PROP_KEY_ALT) != null) {
                this.accessId = info.getProperty(ACCESS_ID_PROP_KEY_ALT);
            }
            if (info.getProperty(ACCESS_KEY_PROP_KEY) != null) {
                this.accessKey = info.getProperty(ACCESS_KEY_PROP_KEY);
            } else if (info.getProperty(ACCESS_KEY_PROP_KEY_ALT) != null) {
                this.accessKey = info.getProperty(ACCESS_KEY_PROP_KEY_ALT);
            }
            if (info.getProperty(PROJECT_PROP_KEY) != null) {
                this.project = info.getProperty(PROJECT_PROP_KEY);
            }
            if (info.getProperty("charset") != null) {
                this.charset = info.getProperty("charset");
            }
            if (info.getProperty(LOGVIEW_HOST_PROP_KEY) != null) {
                this.logview = info.getProperty(LOGVIEW_HOST_PROP_KEY);
            }
            if (info.getProperty("lifecycle") != null) {
                this.lifecycle = info.getProperty("lifecycle");
            }
            if (info.getProperty(LOGLEVEL_PROP_KEY) != null) {
                this.logLevel = info.getProperty(LOGLEVEL_PROP_KEY);
            }
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getProject() {
        return this.project;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getLogview() {
        return this.logview;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public String getLogLevel() {
        return this.logLevel;
    }
}

