/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import com.aliyun.odps.jdbc.OdpsDriver;
import com.aliyun.odps.jdbc.utils.LoggerFactory;
import com.aliyun.odps.jdbc.utils.OdpsFormatter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import org.slf4j.Logger;

public class OdpsLogger {
    private static final String DEFAULT_OUTPUT_DIR = "/tmp";
    private static Map<String, FileHandler> pathToFileHandler = new ConcurrentHashMap<String, FileHandler>();
    private boolean enableOdpsLogger = false;
    private java.util.logging.Logger odpsLogger;
    private Logger sl4jLogger;

    public OdpsLogger(String name, String connectionId, String outputPath, String configFilePath, boolean toConsole, boolean enableOdpsLogger) {
        this.enableOdpsLogger = enableOdpsLogger;
        Objects.requireNonNull(name);
        if (outputPath == null) {
            outputPath = OdpsLogger.getDefaultOutputPath();
        }
        if (enableOdpsLogger) {
            this.odpsLogger = java.util.logging.Logger.getLogger(name);
            this.odpsLogger.setLevel(Level.ALL);
            if (toConsole) {
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new OdpsFormatter(connectionId));
                consoleHandler.setLevel(Level.ALL);
                this.odpsLogger.addHandler(consoleHandler);
            }
            try {
                FileHandler fileHandler;
                if (pathToFileHandler.containsKey(outputPath)) {
                    fileHandler = pathToFileHandler.get(outputPath);
                } else {
                    fileHandler = new FileHandler(outputPath, true);
                    fileHandler.setFormatter(new OdpsFormatter(connectionId));
                    fileHandler.setLevel(Level.ALL);
                    pathToFileHandler.put(outputPath, fileHandler);
                }
                this.odpsLogger.addHandler(fileHandler);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sl4jLogger = LoggerFactory.getLogger(configFilePath, name);
    }

    public synchronized void debug(String msg) {
        if (this.enableOdpsLogger) {
            this.odpsLogger.fine(msg);
        }
        this.sl4jLogger.debug(msg);
    }

    public synchronized void info(String msg) {
        if (this.enableOdpsLogger) {
            this.odpsLogger.info(msg);
        }
        this.sl4jLogger.info(msg);
    }

    public synchronized void warn(String msg) {
        if (this.enableOdpsLogger) {
            this.odpsLogger.warning(msg);
        }
        this.sl4jLogger.warn(msg);
    }

    public synchronized void error(String msg) {
        if (this.enableOdpsLogger) {
            this.odpsLogger.severe(msg);
        }
        this.sl4jLogger.error(msg);
    }

    public synchronized void error(String msg, Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        if (this.enableOdpsLogger) {
            this.odpsLogger.severe(msg);
            this.odpsLogger.severe(sw.toString());
        }
        this.sl4jLogger.error(msg, e);
    }

    public static String getDefaultOutputPath() {
        String outputPath;
        try {
            outputPath = new File(OdpsDriver.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (Exception e) {
            outputPath = DEFAULT_OUTPUT_DIR;
        }
        return Paths.get(outputPath, "jdbc.log").toString();
    }
}

