/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.utils.CodingUtils;
import com.aliyun.common.utils.DateUtil;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.oss.internal.OSSExceptionFactory;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.model.AccessControlList;
import com.aliyun.openservices.oss.model.Bucket;
import com.aliyun.openservices.oss.model.BucketLoggingResult;
import com.aliyun.openservices.oss.model.BucketWebsiteResult;
import com.aliyun.openservices.oss.model.CannedAccessControlList;
import com.aliyun.openservices.oss.model.CompleteMultipartUploadResult;
import com.aliyun.openservices.oss.model.CopyObjectResult;
import com.aliyun.openservices.oss.model.GroupGrantee;
import com.aliyun.openservices.oss.model.InitiateMultipartUploadResult;
import com.aliyun.openservices.oss.model.MultipartUpload;
import com.aliyun.openservices.oss.model.MultipartUploadListing;
import com.aliyun.openservices.oss.model.OSSObjectSummary;
import com.aliyun.openservices.oss.model.ObjectListing;
import com.aliyun.openservices.oss.model.ObjectMetadata;
import com.aliyun.openservices.oss.model.Owner;
import com.aliyun.openservices.oss.model.PartListing;
import com.aliyun.openservices.oss.model.PartSummary;
import com.aliyun.openservices.oss.model.Permission;
import com.aliyun.openservices.oss.model.SetBucketCORSRequest;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public final class ResponseParser {
    private static Element getRootElement(InputStream in) throws ClientException {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(in);
            return doc.getRootElement();
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException(OSSUtils.OSS_RESOURCE_MANAGER.getString("ParseError"), e);
        }
    }

    public static ObjectListing parseListObjects(InputStream in) throws ClientException {
        ObjectListing objectListing = new ObjectListing();
        try {
            Element root = ResponseParser.getRootElement(in);
            Namespace ns = root.getNamespace();
            objectListing.setBucketName(root.getChildText("Name", ns));
            objectListing.setPrefix(root.getChildText("Prefix", ns));
            objectListing.setMarker(root.getChildText("Marker", ns));
            objectListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys", ns)));
            objectListing.setDelimiter(root.getChildText("Delimiter", ns));
            objectListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated", ns)));
            objectListing.setNextMarker(root.getChildText("NextMarker", ns));
            List<OSSObjectSummary> contents = objectListing.getObjectSummaries();
            List tempList = root.getChildren("Contents", ns);
            for (Element e : tempList) {
                OSSObjectSummary ossObjectSummary = new OSSObjectSummary();
                ossObjectSummary.setKey(e.getChildText("Key", ns));
                ossObjectSummary.setETag(OSSUtils.trimQuotes(e.getChildText("ETag", ns)));
                ossObjectSummary.setLastModified(DateUtil.parseIso8601Date(e.getChildText("LastModified", ns)));
                ossObjectSummary.setSize(Long.valueOf(e.getChildText("Size", ns)));
                ossObjectSummary.setStorageClass(e.getChildText("StorageClass", ns));
                ossObjectSummary.setBucketName(objectListing.getBucketName());
                String id = e.getChild("Owner", ns).getChildText("ID", ns);
                String displayName = e.getChild("Owner", ns).getChildText("DisplayName", ns);
                ossObjectSummary.setOwner(new Owner(id, displayName));
                contents.add(ossObjectSummary);
            }
            tempList = root.getChildren("CommonPrefixes", ns);
            for (Element e : tempList) {
                objectListing.getCommonPrefixes().add(e.getChildText("Prefix", ns));
            }
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return objectListing;
    }

    public static AccessControlList parseGetBucketAcl(InputStream in) throws ClientException {
        try {
            Element root = ResponseParser.getRootElement(in);
            AccessControlList aclList = new AccessControlList();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            aclList.setOwner(owner);
            String acl = root.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList cAcl = CannedAccessControlList.parse(acl);
            if (cAcl == CannedAccessControlList.PublicRead) {
                aclList.grantPermission(GroupGrantee.AllUsers, Permission.Read);
            } else if (cAcl == CannedAccessControlList.PublicReadWrite) {
                aclList.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
            }
            return aclList;
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException(OSSUtils.OSS_RESOURCE_MANAGER.getString("ParseError"), e);
        }
    }

    public static List<Bucket> parseListBucket(InputStream in) throws ClientException {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        try {
            Element root = ResponseParser.getRootElement(in);
            Namespace ns = root.getNamespace();
            Element ownerEle = root.getChild("Owner", ns);
            String id = ownerEle.getChildText("ID", ns);
            String displayName = ownerEle.getChildText("DisplayName", ns);
            Owner owner = new Owner(id, displayName);
            Element bucketsEle = root.getChild("Buckets", ns);
            for (Element ele : bucketsEle.getChildren("Bucket", ns)) {
                Bucket bucket = new Bucket();
                bucket.setOwner(owner);
                bucket.setName(ele.getChildText("Name", ns));
                bucket.setCreationDate(DateUtil.parseIso8601Date(ele.getChildText("CreationDate", ns)));
                buckets.add(bucket);
            }
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return buckets;
    }

    public static String parseGetBucketLocation(InputStream in) throws ClientException {
        try {
            Element root = ResponseParser.getRootElement(in);
            return root.getText();
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
    }

    public static ObjectMetadata getObjectMetadata(Map<String, String> headers) throws ClientException {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        try {
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    key = key.substring("x-oss-meta-".length());
                    objectMetadata.addUserMetadata(key, headers.get("x-oss-meta-" + key));
                    continue;
                }
                if (key.equals("Last-Modified")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException e1) {
                        throw new ClientException(e1);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMetadata.setHeader(key, OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return objectMetadata;
    }

    public static InitiateMultipartUploadResult parseInitiateMultipartUpload(InputStream in) throws ClientException {
        Element root = ResponseParser.getRootElement(in);
        InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
        try {
            String bucketName = root.getChildText("Bucket");
            String key = root.getChildText("Key");
            String uploadId = root.getChildText("UploadId");
            result.setBucketName(bucketName);
            result.setKey(key);
            result.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static MultipartUploadListing parseListMultipartUploads(InputStream in) throws ClientException {
        Element root = ResponseParser.getRootElement(in);
        MultipartUploadListing result = new MultipartUploadListing();
        try {
            result.setBucketName(root.getChildText("Bucket"));
            List tempList = root.getChildren("CommonPrefixes");
            for (Element e : tempList) {
                result.getCommonPrefixes().add(e.getChildText("Prefix"));
            }
            result.setDelimiter(root.getChildText("Delimiter"));
            result.setKeyMarker(root.getChildText("KeyMarker"));
            result.setMaxUploads(Integer.valueOf(root.getChildText("MaxUploads")));
            ArrayList<MultipartUpload> multipartUploads = new ArrayList<MultipartUpload>();
            result.setMultipartUploads(multipartUploads);
            for (Element ele : root.getChildren("Upload")) {
                MultipartUpload part = new MultipartUpload();
                if (ele.getChild("Initiated") == null) continue;
                multipartUploads.add(part);
                part.setInitiated(DateUtil.parseIso8601Date(ele.getChildText("Initiated")));
                part.setKey(ele.getChildText("Key"));
                part.setStorageClass(ele.getChildText("StorageClass"));
                part.setUploadId(ele.getChildText("UploadId"));
            }
            result.setNextKeyMarker(root.getChildText("NextKeyMarker"));
            result.setNextUploadIdMarker(root.getChildText("NextUploadIdMarker"));
            result.setPrefix(root.getChildText("Prefix"));
            result.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            result.setUploadIdMarker(root.getChildText("UploadIdMarker"));
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static PartListing parseListParts(InputStream in) throws ClientException {
        Element root = ResponseParser.getRootElement(in);
        PartListing result = new PartListing();
        try {
            result.setBucketName(root.getChildText("Bucket"));
            Owner initiator = new Owner();
            if (root.getChild("Initiator") != null) {
                initiator.setId(root.getChild("Initiator").getChildText("ID"));
                initiator.setDisplayName(root.getChild("Initiator").getChildText("DisplayName"));
            }
            result.setInitiator(initiator);
            result.setKey(root.getChildText("Key"));
            result.setMaxParts(Integer.valueOf(root.getChildText("MaxParts")));
            String nextPartNumberMarkerText = root.getChildText("NextPartNumberMarker");
            if (!CodingUtils.isNullOrEmpty(nextPartNumberMarkerText)) {
                result.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarkerText));
            }
            Owner owner = new Owner();
            if (root.getChild("Owner") != null) {
                owner.setId(root.getChild("Owner").getChildText("ID"));
                owner.setDisplayName(root.getChild("Owner").getChildText("DisplayName"));
            }
            result.setOwner(owner);
            String partNumberMarkerText = root.getChildText("PartNumberMarker");
            if (!CodingUtils.isNullOrEmpty(partNumberMarkerText)) {
                result.setPartNumberMarker(Integer.valueOf(partNumberMarkerText));
            }
            ArrayList<PartSummary> parts = new ArrayList<PartSummary>();
            result.setParts(parts);
            for (Element ele : root.getChildren("Part")) {
                PartSummary part = new PartSummary();
                parts.add(part);
                part.setETag(OSSUtils.trimQuotes(ele.getChildText("ETag")));
                part.setLastModified(DateUtil.parseIso8601Date(ele.getChildText("LastModified")));
                part.setPartNumber(Integer.valueOf(ele.getChildText("PartNumber")));
                part.setSize(Integer.valueOf(ele.getChildText("Size")).intValue());
            }
            result.setStorageClass(root.getChildText("StorageClass"));
            result.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            result.setUploadId(root.getChildText("UploadId"));
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static CompleteMultipartUploadResult parseCompleteMultipartUpload(InputStream in) throws ClientException {
        Element root = ResponseParser.getRootElement(in);
        CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
        try {
            result.setBucketName(root.getChildText("Bucket"));
            result.setETag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            result.setKey(root.getChildText("Key"));
            result.setLocation(root.getChildText("Location"));
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static BucketLoggingResult parseBucketLogging(InputStream in) throws ClientException {
        Element root = ResponseParser.getRootElement(in);
        BucketLoggingResult result = new BucketLoggingResult();
        try {
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetBucket(root.getChild("LoggingEnabled").getChildText("TargetBucket"));
            }
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetPrefix(root.getChild("LoggingEnabled").getChildText("TargetPrefix"));
            }
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static BucketWebsiteResult parseBucketWebsite(InputStream in) throws ClientException {
        Element root = ResponseParser.getRootElement(in);
        BucketWebsiteResult result = new BucketWebsiteResult();
        try {
            if (root.getChild("IndexDocument") != null) {
                result.setIndexDocument(root.getChild("IndexDocument").getChildText("Suffix"));
            }
            if (root.getChild("ErrorDocument") != null) {
                result.setErrorDocument(root.getChild("ErrorDocument").getChildText("Key"));
            }
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static CopyObjectResult parseCopyObjectResult(InputStream content) throws ClientException {
        Element root = ResponseParser.getRootElement(content);
        CopyObjectResult result = new CopyObjectResult();
        try {
            result.setLastModified(DateUtil.parseIso8601Date(root.getChildText("LastModified")));
            result.setEtag(OSSUtils.trimQuotes(root.getChildText("ETag")));
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return result;
    }

    public static List<SetBucketCORSRequest.CORSRule> parseListBucketCORS(InputStream in) throws ClientException {
        ArrayList<SetBucketCORSRequest.CORSRule> corsRules = new ArrayList<SetBucketCORSRequest.CORSRule>();
        try {
            Element root = ResponseParser.getRootElement(in);
            List corsRuleElements = root.getChildren("CORSRule");
            for (Element corsRulelement : corsRuleElements) {
                SetBucketCORSRequest.CORSRule rule = new SetBucketCORSRequest.CORSRule();
                List allowedOriginElements = corsRulelement.getChildren("AllowedOrigin");
                for (Element allowedOriginElement : allowedOriginElements) {
                    rule.getAllowedOrigins().add(allowedOriginElement.getValue());
                }
                List allowedMethodElements = corsRulelement.getChildren("AllowedMethod");
                for (Element allowedMethodElement : allowedMethodElements) {
                    rule.getAllowedMethods().add(allowedMethodElement.getValue());
                }
                List allowedHeaderElements = corsRulelement.getChildren("AllowedHeader");
                for (Element allowedHeaderElement : allowedHeaderElements) {
                    rule.getAllowedHeaders().add(allowedHeaderElement.getValue());
                }
                List exposeHeaderElements = corsRulelement.getChildren("ExposedHeader");
                for (Element exposeHeaderElement : exposeHeaderElements) {
                    rule.getExposeHeaders().add(exposeHeaderElement.getValue());
                }
                Element maxAgeSecondsElement = corsRulelement.getChild("MaxAgeSecondes");
                if (maxAgeSecondsElement != null) {
                    rule.setMaxAgeSeconds(ResponseParser.parseInteger(maxAgeSecondsElement.getValue()));
                }
                corsRules.add(rule);
            }
        }
        catch (Exception e) {
            throw OSSExceptionFactory.createInvalidResponseException("respones builder error", e);
        }
        return corsRules;
    }

    private static Integer parseInteger(Object obj) {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return null;
        }
    }
}

