/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.comm.RequestMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    private static final String NEW_LINE = "\n";
    private static final List<String> SIGNED_PARAMTERS = Arrays.asList("acl", "uploadId", "partNumber", "uploads", "location", "cors", "logging", "website", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires");

    public static String buildCanonicalString(String method, String resourcePath, RequestMessage request, String expires) {
        StringBuilder builder = new StringBuilder();
        builder.append(method + NEW_LINE);
        Map<String, String> headers = request.getHeaders();
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String lowerKey;
                if (entry.getKey() == null || !(lowerKey = entry.getKey().toLowerCase()).equals("Content-Type".toLowerCase()) && !lowerKey.equals("Content-MD5".toLowerCase()) && !lowerKey.equals("Date".toLowerCase()) && !lowerKey.startsWith("x-oss-")) continue;
                headersToSign.put(lowerKey, entry.getValue());
            }
        }
        if (!headersToSign.containsKey("Content-Type".toLowerCase())) {
            headersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!headersToSign.containsKey("Content-MD5".toLowerCase())) {
            headersToSign.put("Content-MD5".toLowerCase(), "");
        }
        if (request.getParameters() != null) {
            for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
                if (!entry.getKey().startsWith("x-oss-")) continue;
                headersToSign.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : headersToSign.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("x-oss-")) {
                builder.append(key).append(':').append((Object)value);
            } else {
                builder.append((Object)value);
            }
            builder.append(NEW_LINE);
        }
        builder.append(SignUtils.buildCanonicalizedResource(resourcePath, request.getParameters()));
        return builder.toString();
    }

    private static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters) {
        assert (resourcePath.startsWith("/"));
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separater = 63;
            for (Object paramName : parameterNames) {
                if (!SIGNED_PARAMTERS.contains(paramName)) continue;
                builder.append((char)separater);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (paramValue != null) {
                    builder.append("=").append(paramValue);
                }
                separater = 38;
            }
        }
        return builder.toString();
    }
}

