/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.DefaultServiceClient;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientConfiguration;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTS;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSDataOperation;
import com.aliyun.openservices.ots.internal.OTSTableOperation;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.BatchGetRowRequest;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.CreateTableRequest;
import com.aliyun.openservices.ots.model.CreateTableResult;
import com.aliyun.openservices.ots.model.DeleteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.DeleteTableRequest;
import com.aliyun.openservices.ots.model.DeleteTableResult;
import com.aliyun.openservices.ots.model.DescribeTableRequest;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.GetRangeRequest;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.GetRowRequest;
import com.aliyun.openservices.ots.model.GetRowResult;
import com.aliyun.openservices.ots.model.ListTableResult;
import com.aliyun.openservices.ots.model.PutRowRequest;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.RangeIteratorParameter;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowIterator;
import com.aliyun.openservices.ots.model.UpdateRowRequest;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import com.aliyun.openservices.ots.model.UpdateTableRequest;
import com.aliyun.openservices.ots.model.UpdateTableResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;

public class OTSClient
implements OTS {
    private URI endpoint;
    private String instanceName;
    private ServiceCredentials credentials;
    private ServiceClient client;
    private OTSServiceConfiguration serviceConfig;
    private OTSTableOperation tableOp;
    private OTSDataOperation dataOp;

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, OTSServiceConfiguration otsConfig) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        CodingUtils.assertStringNotNullOrEmpty(accessKeyId, "accessKeyId");
        CodingUtils.assertStringNotNullOrEmpty(accessKeySecret, "accessKeySecret");
        CodingUtils.assertStringNotNullOrEmpty(instanceName, "instanceName");
        try {
            if (!endpoint.startsWith("http://")) {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointProtocolInvalid"));
            }
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointInvalid"), e);
        }
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret);
        this.client = new DefaultServiceClient(config != null ? config : new ClientConfiguration());
        this.serviceConfig = otsConfig != null ? otsConfig : new OTSServiceConfiguration();
        this.instanceName = instanceName;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    private OTSTableOperation getTableOperation() {
        if (this.tableOp == null) {
            this.tableOp = new OTSTableOperation(this.endpoint, this.instanceName, this.client, this.credentials, this.serviceConfig);
        }
        return this.tableOp;
    }

    private OTSDataOperation getDataOperation() {
        if (this.dataOp == null) {
            this.dataOp = new OTSDataOperation(this.endpoint, this.instanceName, this.client, this.credentials, this.serviceConfig);
        }
        return this.dataOp;
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws OTSException, ClientException {
        return this.getTableOperation().createTable(createTableRequest);
    }

    @Override
    public ListTableResult listTable() throws OTSException, ClientException {
        return this.getTableOperation().listTables();
    }

    @Override
    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws OTSException, ClientException {
        return this.getTableOperation().describeTable(describeTableRequest);
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws OTSException, ClientException {
        return this.getTableOperation().deleteTable(deleteTableRequest);
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) throws OTSException, ClientException {
        return this.getTableOperation().updateTable(updateTableRequest);
    }

    @Override
    public GetRowResult getRow(GetRowRequest getRowRequest) throws OTSException, ClientException {
        return this.getDataOperation().getRow(getRowRequest);
    }

    @Override
    public PutRowResult putRow(PutRowRequest putRowRequest) throws OTSException, ClientException {
        return this.getDataOperation().putRow(putRowRequest);
    }

    @Override
    public UpdateRowResult updateRow(UpdateRowRequest updateRowRequest) throws OTSException, ClientException {
        return this.getDataOperation().updateRow(updateRowRequest);
    }

    @Override
    public DeleteRowResult deleteRow(DeleteRowRequest deleteRowRequest) throws OTSException, ClientException {
        return this.getDataOperation().deleteRow(deleteRowRequest);
    }

    @Override
    public BatchGetRowResult batchGetRow(BatchGetRowRequest batchGetRowRequest) throws OTSException, ClientException {
        return this.getDataOperation().batchGetRow(batchGetRowRequest);
    }

    @Override
    public BatchWriteRowResult batchWriteRow(BatchWriteRowRequest batchWriteRowRequest) throws OTSException, ClientException {
        return this.getDataOperation().batchWriteRow(batchWriteRowRequest);
    }

    @Override
    public GetRangeResult getRange(GetRangeRequest getRangeRequest) throws OTSException, ClientException {
        return this.getDataOperation().getRange(getRangeRequest);
    }

    @Override
    public Iterator<Row> createRangeIterator(RangeIteratorParameter rangeIteratorParameter) throws OTSException, ClientException {
        return new RowIterator(this, rangeIteratorParameter);
    }
}

