/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.BatchGetRowRequest;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.DeleteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.GetRangeRequest;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.GetRowRequest;
import com.aliyun.openservices.ots.model.GetRowResult;
import com.aliyun.openservices.ots.model.MultiRowQueryCriteria;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.OTSResultFactory;
import com.aliyun.openservices.ots.model.PutRowRequest;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.RowUpdateChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.model.UpdateRowRequest;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import com.google.protobuf.Message;
import java.net.URI;
import java.util.Map;

public class OTSDataOperation
extends OTSOperation {
    private static final String ACTION_GET_ROW = "GetRow";
    private static final String ACTION_PUT_ROW = "PutRow";
    private static final String ACTION_UPDATE_ROW = "UpdateRow";
    private static final String ACTION_DELETE_ROW = "DeleteRow";
    private static final String ACTION_BATCH_GET_ROW = "BatchGetRow";
    private static final String ACTION_BATCH_WRITE_ROW = "BatchWriteRow";
    private static final String ACTION_GET_RANGE = "GetRange";

    public OTSDataOperation(URI endpoint, String instanceName, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(endpoint, instanceName, client, credentials, serviceConfig);
    }

    public OTSDataOperation(URI endpoint, String instanceName, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, instanceName, client, credentials, new OTSServiceConfiguration());
    }

    public GetRowResult getRow(GetRowRequest getRowRequest) {
        CodingUtils.assertParameterNotNull(getRowRequest, "getRowRequest");
        SingleRowQueryCriteria criteria = getRowRequest.getRowQueryCriteria();
        if (criteria.getRowPrimaryKey().getPrimaryKey().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_GET_ROW, HttpMethod.POST, null, OTSProtocolHelper.buildGetRowRequest(criteria), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.GetRowResponse.getDefaultInstance()));
        OtsProtocol2.GetRowResponse response = (OtsProtocol2.GetRowResponse)result.getMessage();
        return OTSResultFactory.createGetRowResult(result, response);
    }

    public PutRowResult putRow(PutRowRequest putRowRequest) {
        CodingUtils.assertParameterNotNull(putRowRequest, "putRowRequest");
        RowPutChange rowChange = putRowRequest.getRowChange();
        if (rowChange.getRowPrimaryKey().getPrimaryKey().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_PUT_ROW, HttpMethod.POST, null, OTSProtocolHelper.buildPutRowRequest(rowChange), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.PutRowResponse.getDefaultInstance()));
        OtsProtocol2.PutRowResponse putRowResponse = (OtsProtocol2.PutRowResponse)result.getMessage();
        return OTSResultFactory.createPutRowResult(result, putRowResponse);
    }

    public UpdateRowResult updateRow(UpdateRowRequest updateRowRequest) {
        CodingUtils.assertParameterNotNull(updateRowRequest, "updateRowRequest");
        RowUpdateChange rowChange = updateRowRequest.getRowChange();
        if (rowChange.getRowPrimaryKey().getPrimaryKey().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_UPDATE_ROW, HttpMethod.POST, null, OTSProtocolHelper.buildUpdateRowRequest(rowChange), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.UpdateRowResponse.getDefaultInstance()));
        OtsProtocol2.UpdateRowResponse updateRowResponse = (OtsProtocol2.UpdateRowResponse)result.getMessage();
        return OTSResultFactory.createUpdateRowResult(result, updateRowResponse);
    }

    public DeleteRowResult deleteRow(DeleteRowRequest deleteRowRequest) {
        CodingUtils.assertParameterNotNull(deleteRowRequest, "deleteRowRequest");
        RowDeleteChange rowChange = deleteRowRequest.getRowChange();
        if (rowChange.getRowPrimaryKey().getPrimaryKey().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_DELETE_ROW, HttpMethod.POST, null, OTSProtocolHelper.buildDeleteRowRequest(rowChange), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.DeleteRowResponse.getDefaultInstance()));
        OtsProtocol2.DeleteRowResponse deleteRowResponse = (OtsProtocol2.DeleteRowResponse)result.getMessage();
        return OTSResultFactory.createDeleteRowResult(result, deleteRowResponse);
    }

    public BatchGetRowResult batchGetRow(BatchGetRowRequest batchGetRowRequest) {
        CodingUtils.assertParameterNotNull(batchGetRowRequest, "batchGetRowRequest");
        Map<String, MultiRowQueryCriteria> criteriasGroupByTable = batchGetRowRequest.getCriteriasByTable();
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_BATCH_GET_ROW, HttpMethod.POST, null, OTSProtocolHelper.buildBatchGetRowRequest(criteriasGroupByTable), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.BatchGetRowResponse.getDefaultInstance()));
        OtsProtocol2.BatchGetRowResponse batchGetRowResponse = (OtsProtocol2.BatchGetRowResponse)result.getMessage();
        return OTSResultFactory.createBatchGetRowResult(result, batchGetRowResponse);
    }

    public BatchWriteRowResult batchWriteRow(BatchWriteRowRequest batchWriteRowRequest) {
        CodingUtils.assertParameterNotNull(batchWriteRowRequest, "batchWriteRowRequest");
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_BATCH_WRITE_ROW, HttpMethod.POST, null, OTSProtocolHelper.buildBatchWriteRowRequest(batchWriteRowRequest.getRowPutChange(), batchWriteRowRequest.getRowUpdateChange(), batchWriteRowRequest.getRowDeleteChange()), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.BatchWriteRowResponse.getDefaultInstance()));
        OtsProtocol2.BatchWriteRowResponse batchWriteRowResponse = (OtsProtocol2.BatchWriteRowResponse)result.getMessage();
        return OTSResultFactory.createBatchWriteRowResult(result, batchWriteRowResponse);
    }

    public GetRangeResult getRange(GetRangeRequest getRangeRequest) {
        CodingUtils.assertParameterNotNull(getRangeRequest, "getRangeRequest");
        RangeRowQueryCriteria criteria = getRangeRequest.getRangeRowQueryCriteria();
        if (criteria.getInclusiveStartPrimaryKey() == null || criteria.getExclusiveEndPrimaryKey() == null) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetCriteriaRange"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_GET_RANGE, HttpMethod.POST, null, OTSProtocolHelper.buildGetRangeRequest(criteria), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.GetRangeResponse.getDefaultInstance()));
        OtsProtocol2.GetRangeResponse getRangeResponse = (OtsProtocol2.GetRangeResponse)result.getMessage();
        return OTSResultFactory.createGetRangeResult(result, getRangeResponse);
    }
}

