/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class OTSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws OTSException, ClientException {
        assert (responseData != null);
        if (responseData.isSuccessful()) {
            return;
        }
        Map<String, String> headers = responseData.getHeaders();
        if (responseData.getStatusCode() == 301) {
            if (!headers.containsKey("Location")) {
                throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "Location"), null);
            }
            String location = headers.get("Location");
            throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MovedPermanently", location), null);
        }
        InputStream errorStream = responseData.getContent();
        if (errorStream == null) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        if (!headers.containsKey("x-ots-requestid")) {
            throw new ClientException("InvalidResponse", "OTS returns a response with status code: " + responseData.getStatusCode() + ".", null);
        }
        try {
            OtsProtocol2.Error errMsg = OtsProtocol2.Error.parseFrom(errorStream);
            throw OTSExceptionFactory.create(errMsg, headers.get("x-ots-requestid"));
        }
        catch (IOException e) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), e);
        }
    }
}

