/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;

public class OTSExceptionFactory {
    public static OTSException create(String message, Throwable cause) {
        return new OTSException(message, cause);
    }

    public static OTSException create(String message, Throwable cause, String errorCode, String requestId, String hostId) {
        return new OTSException(message, cause, errorCode, requestId);
    }

    public static ClientException createResponseException(String message, Throwable cause) {
        return new ClientException("InvalidResponse", OTSUtil.OTS_RESOURCE_MANAGER.getString("ResponseInvalid") + message, cause);
    }

    public static OTSException create(OtsProtocol2.Error errMsg, String requestId) {
        assert (errMsg != null);
        return new OTSException(errMsg.getMessage(), null, errMsg.getCode(), requestId);
    }
}

