/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.parser.ResultParseException;
import com.aliyun.common.parser.ResultParser;
import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.OTSResult;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UninitializedMessageException;
import java.util.Map;

public class ProtocolBufferParser
implements ResultParser {
    private Message message;

    public ProtocolBufferParser(Message message) {
        assert (message != null);
        this.message = message;
    }

    @Override
    public Object getObject(ResponseMessage response) throws ResultParseException {
        Map<String, String> headers = response.getHeaders();
        if (!headers.containsKey("x-ots-requestid")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-requestid"), null);
        }
        try {
            Message result = this.message.newBuilderForType().mergeFrom(response.getContent()).buildPartial();
            if (!result.isInitialized()) {
                throw new UninitializedMessageException((MessageLite)result).asInvalidProtocolBufferException();
            }
            return new ResponseContentWithMeta(result, new OTSResult(headers.get("x-ots-requestid")));
        }
        catch (Exception e) {
            throw new ResultParseException(ResourceManager.getInstance("common").getString("FailedToParseResponse"), e);
        }
    }
}

