/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.Error;
import com.aliyun.openservices.ots.model.OTSResult;
import com.aliyun.openservices.ots.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetRowResult
extends OTSResult {
    private Map<String, List<RowStatus>> tableToRowsStatus = new HashMap<String, List<RowStatus>>();

    BatchGetRowResult(OTSResult meta) {
        super(meta);
    }

    void addResult(String tableName, RowStatus status) {
        List<RowStatus> tableRowStatus = this.tableToRowsStatus.get(tableName);
        if (tableRowStatus == null) {
            tableRowStatus = new ArrayList<RowStatus>();
            this.tableToRowsStatus.put(tableName, tableRowStatus);
        }
        tableRowStatus.add(status);
    }

    public List<RowStatus> getBatchGetRowStatus(String tableName) {
        return this.tableToRowsStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getTableToRowsStatus() {
        return this.tableToRowsStatus;
    }

    public static class RowStatus {
        private boolean isSucceed = false;
        private Error error;
        private Row row;
        private ConsumedCapacity consumedCapacity;

        public RowStatus(Error error) {
            this.isSucceed = false;
            this.error = error;
        }

        public RowStatus(Row row, ConsumedCapacity consumedCapacity) {
            this.isSucceed = true;
            this.row = row;
            this.consumedCapacity = consumedCapacity;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public Error getError() {
            return this.error;
        }

        public Row getRow() {
            return this.row;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }
    }
}

